/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.network.PacketGetPlayers;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiMatterReceiver
extends GenericGuiContainer<MatterReceiverTileEntity> {
    public static final int MATTER_WIDTH = 180;
    public static final int MATTER_HEIGHT = 160;
    public static final String ACCESS_PRIVATE = "Private";
    public static final String ACCESS_PUBLIC = "Public";
    private EnergyBar energyBar;
    private ChoiceLabel privateSetting;
    private WidgetList allowedPlayers;
    private Button addButton;
    private Button delButton;
    private TextField nameField;
    private List<String> players = null;
    private int listDirty = 0;
    private static Set<String> fromServer_allowedPlayers = new HashSet<String>();

    public static void storeAllowedPlayersForClient(List<String> players) {
        fromServer_allowedPlayers = new HashSet<String>(players);
    }

    public GuiMatterReceiver(MatterReceiverTileEntity matterReceiverTileEntity, EmptyContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)matterReceiverTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "tpreceiver");
        GenericEnergyStorageTileEntity.setCurrentRF((long)matterReceiverTileEntity.getStoredPower());
        this.field_146999_f = 180;
        this.field_147000_g = 160;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        long maxEnergyStored = ((MatterReceiverTileEntity)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setFilledRectThickness(1)).setHorizontal().setDesiredHeight(12)).setDesiredWidth(80)).setMaxValue(maxEnergyStored).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        TextField textField = (TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setName("name")).setTooltips(new String[]{"Use this name to", "identify this receiver", "in the dialer"});
        Panel namePanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Name:"))).addChild((Widget)textField)).setDesiredHeight(16);
        this.privateSetting = ((ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{ACCESS_PUBLIC, ACCESS_PRIVATE}).setDesiredHeight(14)).setDesiredWidth(60)).setName("private")).setChoiceTooltip(ACCESS_PUBLIC, new String[]{"Everyone can dial to this receiver"}).setChoiceTooltip(ACCESS_PRIVATE, new String[]{"Only people in the access list below", "can dial to this receiver"});
        Panel privatePanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Access:"))).addChild((Widget)this.privateSetting)).setDesiredHeight(16);
        this.allowedPlayers = (WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("allowedplayers");
        Slider allowedPlayerSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollableName("allowedplayers");
        Panel allowedPlayersPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChild((Widget)this.allowedPlayers)).addChild((Widget)allowedPlayerSlider)).setFilledBackground(-6381922);
        this.nameField = new TextField(this.field_146297_k, (Gui)this);
        this.addButton = (Button)((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("addplayer")).setText("Add")).setDesiredHeight(13)).setDesiredWidth(34)).setTooltips(new String[]{"Add a player to the access list"});
        this.delButton = (Button)((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("delplayer")).setText("Del")).setDesiredHeight(13)).setDesiredWidth(34)).setTooltips(new String[]{"Remove the selected player", "from the access list"});
        Panel buttonPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChildren(new Widget[]{this.nameField, this.addButton, this.delButton})).setDesiredHeight(16);
        Panel toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)((VerticalLayout)((VerticalLayout)new VerticalLayout().setHorizontalMargin(3)).setVerticalMargin(3)).setSpacing(1)).addChildren(new Widget[]{this.energyBar, namePanel, privatePanel, allowedPlayersPanel, buttonPanel});
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, 180, 160));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        this.listDirty = 0;
        this.requestPlayers();
        ((MatterReceiverTileEntity)this.tileEntity).requestRfFromServer("rftools");
        this.window.bind(RFToolsMessages.INSTANCE, "name", this.tileEntity, MatterReceiverTileEntity.VALUE_NAME.getName());
        this.window.bind(RFToolsMessages.INSTANCE, "private", this.tileEntity, MatterReceiverTileEntity.VALUE_PRIVATE.getName());
        this.window.event("addplayer", (source, params) -> this.addPlayer());
        this.window.event("delplayer", (source, params) -> this.delPlayer());
    }

    private void addPlayer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "receiver.addPlayer", TypedMap.builder().put(MatterReceiverTileEntity.PARAM_PLAYER, (Object)this.nameField.getText()).build());
        this.listDirty = 0;
    }

    private void delPlayer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "receiver.delPlayer", TypedMap.builder().put(MatterReceiverTileEntity.PARAM_PLAYER, (Object)this.nameField.getText()).build());
        this.listDirty = 0;
    }

    private void requestPlayers() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetPlayers(((MatterReceiverTileEntity)this.tileEntity).func_174877_v(), "getPlayers", "getPlayers"));
    }

    private void populatePlayers() {
        ArrayList<String> newPlayers = new ArrayList<String>(fromServer_allowedPlayers);
        Collections.sort(newPlayers);
        if (newPlayers.equals(this.players)) {
            return;
        }
        this.players = new ArrayList<String>(newPlayers);
        this.allowedPlayers.removeChildren();
        for (String player : this.players) {
            this.allowedPlayers.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(StyleConfig.colorTextInListNormal)).setText(player)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        }
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestPlayers();
            this.listDirty = 20;
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populatePlayers();
        this.enableButtons();
        this.drawWindow();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((MatterReceiverTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }

    private void enableButtons() {
        boolean isPrivate = ACCESS_PRIVATE.equals(this.privateSetting.getCurrentChoice());
        this.allowedPlayers.setEnabled(isPrivate);
        this.nameField.setEnabled(isPrivate);
        int isPlayerSelected = this.allowedPlayers.getSelected();
        this.delButton.setEnabled(isPrivate && isPlayerSelected != -1);
        String name = this.nameField.getText();
        this.addButton.setEnabled(isPrivate && name != null && !name.isEmpty());
    }
}

