/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.EntityTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleSupport;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftools.GeneralConfiguration;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spawner.MatterBeamerTileEntity;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.items.ModItems;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpawnerTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
MachineInformation,
ITickable {
    public static final String CMD_GET_SPAWNERINFO = "getSpawnerInfo";
    public static final Key<Double> PARAM_MATTER0 = new Key("matter0", Type.DOUBLE);
    public static final Key<Double> PARAM_MATTER1 = new Key("matter1", Type.DOUBLE);
    public static final Key<Double> PARAM_MATTER2 = new Key("matter2", Type.DOUBLE);
    public static float matterReceived0 = -1.0f;
    public static float matterReceived1 = -1.0f;
    public static float matterReceived2 = -1.0f;
    public static final int SLOT_SYRINGE = 0;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)ModItems.syringeItem)}), "container", 0, 22, 8, 1, 18, 1, 18);
            this.layoutPlayerInventorySlots(10, 70);
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 1);
    static final ModuleSupport MODULE_SUPPORT = new ModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() == ModItems.syringeItem;
        }
    };
    private static final String[] TAGS = new String[]{"matter1", "matter2", "matter3", "mob"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"The amount of matter in the first slot", "The amount of matter in the second slot", "The amount of matter in the third slot", "The name of the mob being spawned"};
    private float[] matter = new float[]{0.0f, 0.0f, 0.0f};
    private boolean checkSyringe = true;
    private String prevMobId = null;
    private String mobId = "";
    private AxisAlignedBB entityCheckBox = null;
    private static long lastTime = 0L;

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public SpawnerTileEntity() {
        super((long)SpawnerConfiguration.SPAWNER_MAXENERGY, (long)SpawnerConfiguration.SPAWNER_RECEIVEPERTICK);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int getTagCount() {
        return TAGS.length;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        switch (index) {
            case 0: {
                return Float.toString(this.matter[0]);
            }
            case 1: {
                return Float.toString(this.matter[1]);
            }
            case 2: {
                return Float.toString(this.matter[2]);
            }
            case 3: {
                return this.mobId;
            }
        }
        return null;
    }

    private void testSyringe() {
        if (!this.checkSyringe) {
            return;
        }
        this.checkSyringe = false;
        this.mobId = null;
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            this.clearMatter();
            return;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            this.clearMatter();
            return;
        }
        this.mobId = tagCompound.func_74779_i("mobId");
        if (this.mobId == null) {
            this.clearMatter();
            return;
        }
        this.mobId = EntityTools.fixEntityId((String)this.mobId);
        int level = tagCompound.func_74762_e("level");
        if (level < GeneralConfiguration.maxMobInjections) {
            this.clearMatter();
            return;
        }
        if (this.prevMobId != null && !this.prevMobId.equals(this.mobId)) {
            this.clearMatter();
        }
    }

    private void clearMatter() {
        if (this.matter[0] != 0.0f || this.matter[1] != 0.0f || this.matter[2] != 0.0f) {
            this.matter[2] = 0.0f;
            this.matter[1] = 0.0f;
            this.matter[0] = 0.0f;
            this.func_70296_d();
        }
    }

    public boolean addMatter(ItemStack stack, int m, float beamerInfusionFactor) {
        SpawnerConfiguration.MobSpawnAmount spawnAmount;
        this.testSyringe();
        if (this.mobId == null || this.mobId.isEmpty()) {
            return false;
        }
        int materialType = 0;
        Float factor = null;
        List<SpawnerConfiguration.MobSpawnAmount> spawnAmounts = this.getSpawnAmounts();
        Iterator<SpawnerConfiguration.MobSpawnAmount> iterator = spawnAmounts.iterator();
        while (iterator.hasNext() && (factor = (spawnAmount = iterator.next()).match(stack)) == null) {
            ++materialType;
        }
        if (factor == null) {
            return false;
        }
        float mm = this.matter[materialType];
        if ((mm += (float)m * factor.floatValue() * 3.0f / (3.0f - beamerInfusionFactor)) > (float)SpawnerConfiguration.maxMatterStorage) {
            mm = SpawnerConfiguration.maxMatterStorage;
        }
        this.matter[materialType] = mm;
        this.func_70296_d();
        return true;
    }

    private List<SpawnerConfiguration.MobSpawnAmount> getSpawnAmounts() {
        boolean isDefault;
        List<SpawnerConfiguration.MobSpawnAmount> spawnAmounts = SpawnerConfiguration.mobSpawnAmounts.get(this.mobId);
        boolean bl = isDefault = spawnAmounts == null;
        if (isDefault) {
            spawnAmounts = SpawnerConfiguration.defaultSpawnAmounts;
        }
        if (spawnAmounts.size() != 3) {
            throw new IllegalStateException("The mob spawn amounts list for mob " + this.mobId + (isDefault ? " (the default list)" : "") + " is the wrong size. Instead of 3 elements, it contained " + spawnAmounts.size());
        }
        return spawnAmounts;
    }

    public float[] getMatter() {
        return this.matter;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        this.testSyringe();
        if (this.mobId == null || this.mobId.isEmpty()) {
            return;
        }
        List<SpawnerConfiguration.MobSpawnAmount> spawnAmounts = this.getSpawnAmounts();
        for (int i = 0; i < 3; ++i) {
            if (!(this.matter[i] < spawnAmounts.get(i).getAmount())) continue;
            return;
        }
        Integer rf = SpawnerConfiguration.mobSpawnRf.get(this.mobId);
        if (rf == null) {
            rf = SpawnerConfiguration.defaultMobSpawnRf;
        }
        rf = (int)((float)rf.intValue() * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getStoredPower() < (long)rf.intValue()) {
            return;
        }
        this.consumeEnergy(rf.intValue());
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.matter[n] = this.matter[n] - spawnAmounts.get(i).getAmount();
        }
        this.func_70296_d();
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing k = OrientationTools.getOrientation((IBlockState)state);
        int sx = this.func_174877_v().func_177958_n();
        int sy = this.func_174877_v().func_177956_o();
        int sz = this.func_174877_v().func_177952_p();
        Vec3i dir = k.func_176730_m();
        sx += dir.func_177958_n();
        sy += dir.func_177956_o();
        sz += dir.func_177952_p();
        EntityLiving entityLiving = EntityTools.createEntity((World)this.func_145831_w(), (String)this.mobId);
        if (entityLiving == null) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobId));
            return;
        }
        if (entityLiving instanceof EntityDragon) {
            NBTTagCompound dragonTag = new NBTTagCompound();
            entityLiving.func_70014_b(dragonTag);
            dragonTag.func_74777_a("DragonPhase", (short)0);
            entityLiving.func_70037_a(dragonTag);
        }
        if (k == EnumFacing.DOWN) {
            sy = (int)((float)sy - (entityLiving.func_70047_e() - 1.0f));
        }
        entityLiving.func_70012_b((double)sx + 0.5, (double)sy, (double)sz + 0.5, 0.0f, 0.0f);
        this.func_145831_w().func_72838_d((Entity)entityLiving);
    }

    public void useWrench(EntityPlayer player) {
        BlockPos coord = RFTools.instance.clientInfo.getSelectedTE();
        if (coord == null) {
            return;
        }
        TileEntity tileEntity = this.func_145831_w().func_175625_s(coord);
        double d = new Vec3d((Vec3i)coord).func_72438_d(new Vec3d((Vec3i)this.func_174877_v()));
        if (d > (double)SpawnerConfiguration.maxBeamDistance) {
            Logging.message((EntityPlayer)player, (String)"Destination distance is too far!");
        } else if (tileEntity instanceof MatterBeamerTileEntity) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)tileEntity;
            matterBeamerTileEntity.setDestination(this.func_174877_v());
            Logging.message((EntityPlayer)player, (String)"Destination set!");
        }
        RFTools.instance.clientInfo.setSelectedTE(null);
        RFTools.instance.clientInfo.setDestinationTE(null);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.matter[0] = tagCompound.func_74760_g("matter0");
        this.matter[1] = tagCompound.func_74760_g("matter1");
        this.matter[2] = tagCompound.func_74760_g("matter2");
        this.mobId = tagCompound.func_74764_b("mobId") ? EntityTools.fixEntityId((String)tagCompound.func_74779_i("mobId")) : null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74776_a("matter0", this.matter[0]);
        tagCompound.func_74776_a("matter1", this.matter[1]);
        tagCompound.func_74776_a("matter2", this.matter[2]);
        if (this.mobId != null && !this.mobId.isEmpty()) {
            tagCompound.func_74778_a("mobId", this.mobId);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public ItemStack func_70298_a(int index, int amount) {
        this.checkSyringe = true;
        this.prevMobId = this.mobId;
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.checkSyringe = true;
        this.prevMobId = this.mobId;
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == ModItems.syringeItem;
    }

    public boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        if (world.field_72995_K) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.note.pling")), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            this.useWrench(player);
        }
        return true;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof SpawnerTileEntity) {
            float[] matter = this.getMatter();
            DecimalFormat fmt = new DecimalFormat("#.##");
            fmt.setRoundingMode(RoundingMode.DOWN);
            probeInfo.text(TextFormatting.GREEN + "Key Matter: " + fmt.format(matter[0]));
            probeInfo.text(TextFormatting.GREEN + "Bulk Matter: " + fmt.format(matter[1]));
            probeInfo.text(TextFormatting.GREEN + "Living Matter: " + fmt.format(matter[2]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof SpawnerTileEntity) {
            if (System.currentTimeMillis() - lastTime > 500L) {
                lastTime = System.currentTimeMillis();
                ((SpawnerTileEntity)te).requestDataFromServer("rftools", CMD_GET_SPAWNERINFO, TypedMap.EMPTY);
            }
            if (matterReceived0 >= 0.0f) {
                DecimalFormat fmt = new DecimalFormat("#.##");
                fmt.setRoundingMode(RoundingMode.DOWN);
                currenttip.add(TextFormatting.GREEN + "Key Matter: " + fmt.format(matterReceived0));
                currenttip.add(TextFormatting.GREEN + "Bulk Matter: " + fmt.format(matterReceived1));
                currenttip.add(TextFormatting.GREEN + "Living Matter: " + fmt.format(matterReceived2));
            }
        }
    }

    @Nullable
    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GET_SPAWNERINFO.equals(command)) {
            return TypedMap.builder().put(PARAM_MATTER0, (Object)this.matter[0]).put(PARAM_MATTER1, (Object)this.matter[1]).put(PARAM_MATTER2, (Object)this.matter[2]).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return rc;
        }
        if (CMD_GET_SPAWNERINFO.equals(command)) {
            matterReceived0 = ((Double)result.get(PARAM_MATTER0)).floatValue();
            matterReceived1 = ((Double)result.get(PARAM_MATTER1)).floatValue();
            matterReceived2 = ((Double)result.get(PARAM_MATTER2)).floatValue();
            return true;
        }
        return false;
    }
}

