/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericItemBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.RFTools;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.ITooltipInfo;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.screens.GuiScreen;
import mcjty.rftools.blocks.screens.ScreenContainer;
import mcjty.rftools.blocks.screens.ScreenHitTileEntity;
import mcjty.rftools.blocks.screens.ScreenRenderer;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ScreenBlock
extends GenericRFToolsBlock<ScreenTileEntity, ScreenContainer> {
    public static final PropertyDirection HORIZONTAL_FACING = PropertyDirection.func_177712_a((String)"horizontal_facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static long lastTime = 0L;
    private static Setup[] transitions = new Setup[]{new Setup(0, false), new Setup(0, true), new Setup(1, false), new Setup(1, true), new Setup(2, false), new Setup(2, true)};
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    public static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);

    public ScreenBlock(String name, Class<? extends ScreenTileEntity> clazz) {
        super(Material.field_151573_f, clazz, ScreenContainer::new, GenericItemBlock::new, name, true);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)HORIZONTAL_FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 5) {
            meta -= 4;
        } else if (meta > 1) {
            EnumFacing facing = EnumFacing.field_82609_l[meta];
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)HORIZONTAL_FACING, (Comparable)facing);
        }
        EnumFacing horizontalFacing = EnumFacing.field_82609_l[(meta >> 1) + 2];
        EnumFacing facing = (meta & 1) == 0 ? EnumFacing.DOWN : EnumFacing.UP;
        return this.func_176223_P().func_177226_a((IProperty)HORIZONTAL_FACING, (Comparable)horizontalFacing).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing horizontalFacing = (EnumFacing)state.func_177229_b((IProperty)HORIZONTAL_FACING);
        int meta = 0;
        switch (facing) {
            case UP: {
                meta = 1;
            }
            case DOWN: {
                if ((meta += horizontalFacing.func_176745_a() << 1) < 6) {
                    meta -= 4;
                }
                return meta;
            }
        }
        return facing.func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HORIZONTAL_FACING});
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        BlockPos pos = data.getPos();
        this.addProbeInfoScreen(mode, probeInfo, player, world, pos);
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfoScreen(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ScreenTileEntity) {
            IScreenModule<?> module;
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
            if (!screenTileEntity.isConnected() && screenTileEntity.isControllerNeeded()) {
                probeInfo.text(TextFormatting.YELLOW + "[NOT CONNECTED]");
            }
            if (!this.isCreative()) {
                boolean power = screenTileEntity.isPowerOn();
                if (!power) {
                    probeInfo.text(TextFormatting.YELLOW + "[NO POWER]");
                }
                if (mode == ProbeMode.EXTENDED) {
                    int rfPerTick = screenTileEntity.getTotalRfPerTick();
                    probeInfo.text(TextFormatting.GREEN + (power ? "Consuming " : "Needs ") + rfPerTick + " RF/tick");
                }
            }
            if ((module = screenTileEntity.getHoveringModule()) instanceof ITooltipInfo) {
                List<String> info = ((ITooltipInfo)((Object)module)).getInfo(world, screenTileEntity.getHoveringX(), screenTileEntity.getHoveringY());
                for (String s : info) {
                    probeInfo.text(s);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof ScreenTileEntity) {
            return this.getWailaBodyScreen(currenttip, accessor.getPlayer(), (ScreenTileEntity)te);
        }
        return Collections.emptyList();
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBodyScreen(List<String> currenttip, EntityPlayer player, ScreenTileEntity te) {
        if (!te.isConnected() && te.isControllerNeeded()) {
            currenttip.add(TextFormatting.YELLOW + "[NOT CONNECTED]");
        }
        if (!this.isCreative()) {
            boolean power = te.isPowerOn();
            if (!power) {
                currenttip.add(TextFormatting.YELLOW + "[NO POWER]");
            }
            if (player.func_70093_af()) {
                int rfPerTick = te.getTotalRfPerTick();
                currenttip.add(TextFormatting.GREEN + (power ? "Consuming " : "Needs ") + rfPerTick + " RF/tick");
            }
        }
        if (System.currentTimeMillis() - lastTime > 500L) {
            lastTime = System.currentTimeMillis();
            te.requestDataFromServer("rftools", "getScreenInfo", TypedMap.EMPTY);
        }
        currenttip.addAll(ScreenTileEntity.infoReceived);
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(ScreenTileEntity.class, (TileEntitySpecialRenderer)new ScreenRenderer());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)this), (int)0, ScreenTileEntity.class);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public static boolean hasModuleProvider(ItemStack stack) {
        return stack.func_77973_b() instanceof IModuleProvider || stack.hasCapability(IModuleProvider.CAPABILITY, null);
    }

    public static IModuleProvider getModuleProvider(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IModuleProvider) {
            return (IModuleProvider)item;
        }
        return (IModuleProvider)stack.getCapability(IModuleProvider.CAPABILITY, null);
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0, 10){

            public boolean isModule(ItemStack itemStack) {
                return ScreenBlock.hasModuleProvider(itemStack);
            }
        };
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        if (world.field_72995_K) {
            RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
            screenTileEntity.hitScreenClient(mouseOver.field_72307_f.field_72450_a - (double)pos.func_177958_n(), mouseOver.field_72307_f.field_72448_b - (double)pos.func_177956_o(), mouseOver.field_72307_f.field_72449_c - (double)pos.func_177952_p(), mouseOver.field_178784_b, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)HORIZONTAL_FACING));
        }
    }

    private void setInvisibleBlockSafe(World world, BlockPos pos, int dx, int dy, int dz, EnumFacing facing) {
        int zz;
        int yy = pos.func_177956_o() + dy;
        if (yy < 0 || yy >= world.func_72800_K()) {
            return;
        }
        int xx = pos.func_177958_n() + dx;
        BlockPos posO = new BlockPos(xx, yy, zz = pos.func_177952_p() + dz);
        if (world.func_175623_d(posO)) {
            world.func_180501_a(posO, ScreenSetup.screenHitBlock.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING, (Comparable)facing), 3);
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_175625_s(posO);
            screenHitTileEntity.setRelativeLocation(-dx, -dy, -dz);
        }
    }

    private void setInvisibleBlocks(World world, BlockPos pos, int size) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
        EnumFacing horizontalFacing = (EnumFacing)state.func_177229_b((IProperty)HORIZONTAL_FACING);
        for (int i = 0; i <= size; ++i) {
            for (int j = 0; j <= size; ++j) {
                if (i == 0 && j == 0) continue;
                if (facing == EnumFacing.NORTH) {
                    this.setInvisibleBlockSafe(world, pos, -i, -j, 0, facing);
                    continue;
                }
                if (facing == EnumFacing.SOUTH) {
                    this.setInvisibleBlockSafe(world, pos, i, -j, 0, facing);
                    continue;
                }
                if (facing == EnumFacing.WEST) {
                    this.setInvisibleBlockSafe(world, pos, 0, -i, j, facing);
                    continue;
                }
                if (facing == EnumFacing.EAST) {
                    this.setInvisibleBlockSafe(world, pos, 0, -i, -j, facing);
                    continue;
                }
                if (facing == EnumFacing.UP) {
                    if (horizontalFacing == EnumFacing.NORTH) {
                        this.setInvisibleBlockSafe(world, pos, -i, 0, -j, facing);
                        continue;
                    }
                    if (horizontalFacing == EnumFacing.SOUTH) {
                        this.setInvisibleBlockSafe(world, pos, i, 0, j, facing);
                        continue;
                    }
                    if (horizontalFacing == EnumFacing.WEST) {
                        this.setInvisibleBlockSafe(world, pos, -i, 0, j, facing);
                        continue;
                    }
                    if (horizontalFacing != EnumFacing.EAST) continue;
                    this.setInvisibleBlockSafe(world, pos, i, 0, -j, facing);
                    continue;
                }
                if (facing != EnumFacing.DOWN) continue;
                if (horizontalFacing == EnumFacing.NORTH) {
                    this.setInvisibleBlockSafe(world, pos, -i, 0, j, facing);
                    continue;
                }
                if (horizontalFacing == EnumFacing.SOUTH) {
                    this.setInvisibleBlockSafe(world, pos, i, 0, -j, facing);
                    continue;
                }
                if (horizontalFacing == EnumFacing.WEST) {
                    this.setInvisibleBlockSafe(world, pos, i, 0, j, facing);
                    continue;
                }
                if (horizontalFacing != EnumFacing.EAST) continue;
                this.setInvisibleBlockSafe(world, pos, -i, 0, -j, facing);
            }
        }
    }

    private void clearInvisibleBlockSafe(World world, BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= world.func_72800_K()) {
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() == ScreenSetup.screenHitBlock) {
            world.func_175698_g(pos);
        }
    }

    private void clearInvisibleBlocks(World world, BlockPos pos, IBlockState state, int size) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
        EnumFacing horizontalFacing = (EnumFacing)state.func_177229_b((IProperty)HORIZONTAL_FACING);
        for (int i = 0; i <= size; ++i) {
            for (int j = 0; j <= size; ++j) {
                if (i == 0 && j == 0) continue;
                if (facing == EnumFacing.NORTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, -j, 0));
                    continue;
                }
                if (facing == EnumFacing.SOUTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, -j, 0));
                    continue;
                }
                if (facing == EnumFacing.WEST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(0, -i, j));
                    continue;
                }
                if (facing == EnumFacing.EAST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(0, -i, -j));
                    continue;
                }
                if (facing == EnumFacing.UP) {
                    if (horizontalFacing == EnumFacing.NORTH) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, -j));
                        continue;
                    }
                    if (horizontalFacing == EnumFacing.SOUTH) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, j));
                        continue;
                    }
                    if (horizontalFacing == EnumFacing.WEST) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, j));
                        continue;
                    }
                    if (horizontalFacing != EnumFacing.EAST) continue;
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, -j));
                    continue;
                }
                if (facing != EnumFacing.DOWN) continue;
                if (horizontalFacing == EnumFacing.NORTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, j));
                    continue;
                }
                if (horizontalFacing == EnumFacing.SOUTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, -j));
                    continue;
                }
                if (horizontalFacing == EnumFacing.WEST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, j));
                    continue;
                }
                if (horizontalFacing != EnumFacing.EAST) continue;
                this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, -j));
            }
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        this.cycleSizeTranspMode(world, pos);
        return true;
    }

    public void cycleSizeTranspMode(World world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[(i + 1) % transitions.length];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    public void cycleSizeMode(World world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[(i + 2) % transitions.length];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    public void cycleTranspMode(World world, BlockPos pos) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        for (int i = 0; i < transitions.length; ++i) {
            Setup setup = transitions[i];
            if (setup.isTransparent() != screenTileEntity.isTransparent() || setup.getSize() != screenTileEntity.getSize()) continue;
            Setup next = transitions[i % 2 == 0 ? i + 1 : i - 1];
            screenTileEntity.setTransparent(next.isTransparent());
            screenTileEntity.setSize(next.getSize());
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
            break;
        }
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() == Items.field_151100_aR) {
            int damage = itemStack.func_77952_i();
            if (damage < 0) {
                damage = 0;
            } else if (damage > 15) {
                damage = 15;
            }
            int color = ItemDye.field_150922_c[damage];
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(new BlockPos(x, y, z));
            screenTileEntity.setColor(color);
            return true;
        }
        if (player.func_70093_af()) {
            return super.openGui(world, x, y, z, player);
        }
        if (world.field_72995_K) {
            this.activateOnClient(world, new BlockPos(x, y, z));
        }
        return true;
    }

    private void activateOnClient(World world, BlockPos pos) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos);
        screenTileEntity.hitScreenClient(mouseOver.field_72307_f.field_72450_a - (double)pos.func_177958_n(), mouseOver.field_72307_f.field_72448_b - (double)pos.func_177956_o(), mouseOver.field_72307_f.field_72449_c - (double)pos.func_177952_p(), mouseOver.field_178784_b, (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)HORIZONTAL_FACING));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
        if (facing == EnumFacing.NORTH) {
            return NORTH_AABB;
        }
        if (facing == EnumFacing.SOUTH) {
            return SOUTH_AABB;
        }
        if (facing == EnumFacing.WEST) {
            return WEST_AABB;
        }
        if (facing == EnumFacing.EAST) {
            return EAST_AABB;
        }
        if (facing == EnumFacing.UP) {
            return UP_AABB;
        }
        if (facing == EnumFacing.DOWN) {
            return DOWN_AABB;
        }
        return BLOCK_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getGuiID() {
        return RFTools.GUI_SCREEN;
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<ScreenTileEntity, ScreenContainer, GenericGuiContainer<? super ScreenTileEntity>> getGuiFactory() {
        return GuiScreen::new;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int size = tagCompound.func_74764_b("large") ? (tagCompound.func_74767_n("large") ? 1 : 0) : tagCompound.func_74762_e("size");
            boolean transparent = tagCompound.func_74767_n("transparent");
            if (size == 2) {
                list.add(TextFormatting.BLUE + "Huge screen.");
            } else if (size == 1) {
                list.add(TextFormatting.BLUE + "Large screen.");
            }
            if (transparent) {
                list.add(TextFormatting.BLUE + "Transparent screen.");
            }
            int rc = 0;
            NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
                ItemStack stack;
                NBTTagCompound tag = bufferTagList.func_150305_b(i);
                if (tag == null || (stack = new ItemStack(tag)).func_190926_b()) continue;
                ++rc;
            }
            list.add(TextFormatting.BLUE + String.valueOf(rc) + " modules");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This is a modular screen. As such it doesn't show anything.");
            list.add(TextFormatting.WHITE + "You must insert modules to control what you can see.");
            list.add(TextFormatting.WHITE + "This screen cannot be directly powered. It has to be remotely");
            list.add(TextFormatting.WHITE + "powered by a nearby Screen Controller.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        ScreenTileEntity screenTileEntity;
        TileEntity tileEntity;
        super.func_180633_a(world, pos, state, entityLivingBase, itemStack);
        if (entityLivingBase instanceof EntityPlayer) {
            // empty if block
        }
        if ((tileEntity = world.func_175625_s(pos)) instanceof ScreenTileEntity && (screenTileEntity = (ScreenTileEntity)tileEntity).getSize() > 0) {
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ScreenTileEntity screenTileEntity;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ScreenTileEntity && (screenTileEntity = (ScreenTileEntity)te).getSize() > 0) {
            this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize());
        }
        super.func_180663_b(world, pos, state);
    }

    private static class Setup {
        private final boolean transparent;
        private final int size;

        public Setup(int size, boolean transparent) {
            this.size = size;
            this.transparent = transparent;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isTransparent() {
            return this.transparent;
        }
    }
}

