/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.wireless;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class RedstoneChannels
extends AbstractWorldData<RedstoneChannels> {
    private static final String REDSTONE_CHANNELS_NAME = "RfToolsRedstoneChannels";
    private int lastId = 0;
    private final Map<Integer, RedstoneChannel> channels = new HashMap<Integer, RedstoneChannel>();

    public RedstoneChannels(String name) {
        super(name);
    }

    public void clear() {
        this.channels.clear();
        this.lastId = 0;
    }

    public static RedstoneChannels getChannels(World world) {
        return (RedstoneChannels)RedstoneChannels.getData((World)world, RedstoneChannels.class, (String)REDSTONE_CHANNELS_NAME);
    }

    public RedstoneChannel getOrCreateChannel(int id) {
        RedstoneChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new RedstoneChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public RedstoneChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.channels.clear();
        NBTTagList lst = tagCompound.func_150295_c("channels", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int channel = tc.func_74762_e("channel");
            int v = tc.func_74762_e("value");
            RedstoneChannel value = new RedstoneChannel();
            value.value = v;
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, RedstoneChannel> entry : this.channels.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("channel", entry.getKey().intValue());
            tc.func_74768_a("value", entry.getValue().getValue());
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("channels", (NBTBase)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    public static class RedstoneChannel {
        private int value = 0;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

