/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.light;

import cofh.core.network.PacketBase;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.light.GridLight;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DuctUnitLight
extends DuctUnit<DuctUnitLight, GridLight, Void> {
    private static final Void[] voids = new Void[6];
    boolean lit = false;
    private static DuctUnitLight lightingUpdate = null;

    protected Void[] createTileCache() {
        return voids;
    }

    protected DuctUnitLight[] createDuctCache() {
        return new DuctUnitLight[6];
    }

    public DuctUnitLight(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    @Override
    public boolean isInputTile(@Nullable TileEntity tile, byte side) {
        BlockPos offset = this.pos().func_177972_a(EnumFacing.values()[side]);
        return this.world().func_175667_e(offset) && this.world().func_180495_p(offset).func_185897_m();
    }

    @Override
    @Nonnull
    public DuctToken<DuctUnitLight, GridLight, Void> getToken() {
        return DuctToken.LIGHT;
    }

    @Override
    public GridLight createGrid() {
        return new GridLight(this.world());
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitLight, GridLight, Void> adjDuct, byte side, byte oppositeSide) {
        return true;
    }

    @Override
    @Nullable
    public Void cacheTile(@Nonnull TileEntity tile, byte side) {
        return null;
    }

    @Override
    public int getLightValue() {
        if (this.isLit()) {
            return 15 - (lightingUpdate != null && lightingUpdate != this ? 1 : 0);
        }
        return 0;
    }

    protected void updateLighting() {
        lightingUpdate = this;
        this.parent.updateLighting();
        lightingUpdate = null;
    }

    public boolean isLit() {
        return ServerHelper.isClientWorld((World)this.world()) || this.grid == null ? this.lit : ((GridLight)this.grid).lit;
    }

    @Override
    public void onPlaced(EntityLivingBase living, ItemStack stack) {
        super.onPlaced(living, stack);
        if (ServerHelper.isServerWorld((World)this.world())) {
            this.lit = this.world().func_175640_z(this.pos());
        }
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        this.lit = false;
        EnumFacing[] valid_directions = EnumFacing.field_82609_l;
        for (int i = 0; !this.lit && i < valid_directions.length; ++i) {
            Attachment attachment = this.parent.getAttachment(i);
            if (attachment != null && attachment.shouldRSConnect()) continue;
            EnumFacing dir = valid_directions[i];
            this.lit = this.world().func_175709_b(this.pos().func_177972_a(dir), dir);
        }
        if (this.grid != null && ((GridLight)this.grid).lit != this.lit) {
            ((GridLight)this.grid).upToDate = false;
        }
    }

    @Override
    public void writeToTilePacket(PacketBase packet) {
        packet.addBool(this.lit || this.grid != null && ((GridLight)this.grid).lit);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        boolean b = payload.getBool();
        if (b != this.lit) {
            this.lit = b;
            this.checkLight();
        }
    }

    @Override
    public TextureAtlasSprite getBaseIcon() {
        return super.getBaseIcon();
    }

    public void checkLight() {
        this.updateLighting();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("isLit", this.lit);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.lit = nbt.func_74767_n("isLit");
    }
}

