/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.util.Lazy;
import appeng.util.helpers.ItemHandlerUtil;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WrapperLazyItemHandler
implements IItemHandlerModifiable {
    private final Lazy<IItemHandler> sourceHandler;

    public WrapperLazyItemHandler(Supplier<IItemHandler> source) {
        this.sourceHandler = new Lazy<IItemHandler>(source);
    }

    public int getSlots() {
        return this.sourceHandler.get().getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.sourceHandler.get().getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.sourceHandler.get().insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.sourceHandler.get().extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.sourceHandler.get().getSlotLimit(slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        ItemHandlerUtil.setStackInSlot(this.sourceHandler.get(), slot, stack);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.sourceHandler.get().isItemValid(slot, stack);
    }
}

