/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.ITileDefinition;
import appeng.api.features.IInscriberRecipe;
import appeng.api.features.IInscriberRecipeBuilder;
import appeng.api.features.InscriberProcessType;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileInscriber
extends AENetworkPowerTile
implements IGridTickable,
IUpgradeableHost,
IConfigManagerHost {
    private final int maxProcessingTime = 100;
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    private int processingTime = 0;
    private boolean smash;
    private int finalStep;
    private long clientStart;
    private final AppEngInternalInventory topItemHandler = new AppEngInternalInventory(this, 1, 1);
    private final AppEngInternalInventory bottomItemHandler = new AppEngInternalInventory(this, 1, 1);
    private final AppEngInternalInventory sideItemHandler = new AppEngInternalInventory(this, 2, 1);
    private final IItemHandler topItemHandlerExtern;
    private final IItemHandler bottomItemHandlerExtern;
    private final IItemHandler sideItemHandlerExtern;
    private IInscriberRecipe cachedTask = null;
    private final IItemHandlerModifiable inv = new WrapperChainedItemHandler(new IItemHandler[]{this.topItemHandler, this.bottomItemHandler, this.sideItemHandler});

    public TileInscriber() {
        this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
        this.setInternalMaxPower(1600.0);
        this.getProxy().setIdlePowerUsage(0.0);
        this.settings = new ConfigManager(this);
        ITileDefinition inscriberDefinition = AEApi.instance().definitions().blocks().inscriber();
        this.upgrades = new DefinitionUpgradeInventory(inscriberDefinition, this, this.getUpgradeSlots());
        this.sideItemHandler.setMaxStackSize(1, 64);
        ItemHandlerFilter filter = new ItemHandlerFilter();
        this.topItemHandlerExtern = new WrapperFilteredItemHandler((IItemHandler)this.topItemHandler, filter);
        this.bottomItemHandlerExtern = new WrapperFilteredItemHandler((IItemHandler)this.bottomItemHandler, filter);
        this.sideItemHandlerExtern = new WrapperFilteredItemHandler((IItemHandler)this.sideItemHandler, filter);
    }

    private int getUpgradeSlots() {
        return 3;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean newSmash;
        boolean c = super.readFromStream(data);
        byte slot = data.readByte();
        boolean oldSmash = this.isSmash();
        boolean bl = newSmash = (slot & 0x40) == 64;
        if (oldSmash != newSmash && newSmash) {
            this.setSmash(true);
            this.setClientStart(System.currentTimeMillis());
        }
        for (int num = 0; num < this.inv.getSlots(); ++num) {
            if ((slot & 1 << num) > 0) {
                this.inv.setStackInSlot(num, AEItemStack.fromPacket(data).createItemStack());
                continue;
            }
            this.inv.setStackInSlot(num, ItemStack.field_190927_a);
        }
        this.cachedTask = null;
        return c;
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        int num;
        super.writeToStream(data);
        int slot = this.isSmash() ? 64 : 0;
        for (num = 0; num < this.inv.getSlots(); ++num) {
            if (this.inv.getStackInSlot(num).func_190926_b()) continue;
            slot |= 1 << num;
        }
        data.writeByte(slot);
        for (num = 0; num < this.inv.getSlots(); ++num) {
            if ((slot & 1 << num) <= 0) continue;
            AEItemStack st = AEItemStack.fromItemStack(this.inv.getStackInSlot(num));
            st.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(EnumFacing inForward, EnumFacing inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        this.setPowerSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        for (int h = 0; h < this.upgrades.getSlots(); ++h) {
            ItemStack is = this.upgrades.getStackInSlot(h);
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        try {
            if (slot == 0) {
                this.setProcessingTime(0);
            }
            if (!this.isSmash()) {
                this.markForUpdate();
            }
            this.cachedTask = null;
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber.getMin(), TickRates.Inscriber.getMax(), !this.hasWork(), false);
    }

    private boolean hasWork() {
        if (this.getTask() != null) {
            return true;
        }
        this.setProcessingTime(0);
        return this.isSmash();
    }

    @Nullable
    public IInscriberRecipe getTask() {
        if (this.cachedTask == null) {
            this.cachedTask = this.getTask(this.sideItemHandler.getStackInSlot(0), this.topItemHandler.getStackInSlot(0), this.bottomItemHandler.getStackInSlot(0));
        }
        return this.cachedTask;
    }

    @Nullable
    private IInscriberRecipe getTask(ItemStack input, ItemStack plateA, ItemStack plateB) {
        if (input.func_190926_b() || input.func_190916_E() > 1) {
            return null;
        }
        if (!plateA.func_190926_b() && plateA.func_190916_E() > 1) {
            return null;
        }
        if (!plateB.func_190926_b() && plateB.func_190916_E() > 1) {
            return null;
        }
        IItemDefinition namePress = AEApi.instance().definitions().materials().namePress();
        boolean isNameA = namePress.isSameAs(plateA);
        boolean isNameB = namePress.isSameAs(plateB);
        if (isNameA && isNameB || isNameA && plateB.func_190926_b()) {
            return this.makeNamePressRecipe(input, plateA, plateB);
        }
        if (plateA.func_190926_b() && isNameB) {
            return this.makeNamePressRecipe(input, plateB, plateA);
        }
        for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
            boolean matchB;
            boolean matchA = plateA.func_190926_b() && !recipe.getTopOptional().isPresent() || Platform.itemComparisons().isSameItem(plateA, recipe.getTopOptional().orElse(ItemStack.field_190927_a)) && (plateB.func_190926_b() && !recipe.getBottomOptional().isPresent() || Platform.itemComparisons().isSameItem(plateB, recipe.getBottomOptional().orElse(ItemStack.field_190927_a)));
            boolean bl = matchB = plateB.func_190926_b() && !recipe.getTopOptional().isPresent() || Platform.itemComparisons().isSameItem(plateB, recipe.getTopOptional().orElse(ItemStack.field_190927_a)) && (plateA.func_190926_b() && !recipe.getBottomOptional().isPresent() || Platform.itemComparisons().isSameItem(plateA, recipe.getBottomOptional().orElse(ItemStack.field_190927_a)));
            if (!matchA && !matchB) continue;
            for (ItemStack option : recipe.getInputs()) {
                if (!Platform.itemComparisons().isSameItem(input, option)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSmash()) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                ItemStack outputCopy;
                IInscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getOutput().func_77946_l(), false).func_190926_b()) {
                    this.setProcessingTime(0);
                    if (out.getProcessType() == InscriberProcessType.PRESS) {
                        this.topItemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                        this.bottomItemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                    this.sideItemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                }
                this.saveChanges();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.setSmash(false);
                this.markForUpdate();
            }
        } else {
            try {
                IEnergyGrid eg = this.getProxy().getEnergy();
                IEnergySource src = this;
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades(Upgrades.SPEED);
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    if (this.getProcessingTime() == 0) {
                        this.setProcessingTime(this.getProcessingTime() + speedFactor);
                    } else {
                        this.setProcessingTime(this.getProcessingTime() + ticksSinceLastCall * speedFactor);
                    }
                }
            }
            catch (GridAccessException eg) {
                // empty catch block
            }
            if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                ItemStack outputCopy;
                this.setProcessingTime(this.getMaxProcessingTime());
                IInscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getOutput().func_77946_l(), true).func_190926_b()) {
                    this.setSmash(true);
                    this.finalStep = 0;
                    this.markForUpdate();
                }
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("inv")) {
            return this.getInternalInventory();
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    protected IItemHandler getItemHandlerForSide(@Nonnull EnumFacing facing) {
        if (facing == this.getUp()) {
            return this.topItemHandlerExtern;
        }
        if (facing == this.getUp().func_176734_d()) {
            return this.bottomItemHandlerExtern;
        }
        return this.sideItemHandlerExtern;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public long getClientStart() {
        return this.clientStart;
    }

    private void setClientStart(long clientStart) {
        this.clientStart = clientStart;
    }

    public boolean isSmash() {
        return this.smash;
    }

    public void setSmash(boolean smash) {
        this.smash = smash;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    private IInscriberRecipe makeNamePressRecipe(ItemStack input, ItemStack plateA, ItemStack plateB) {
        NBTTagCompound tag;
        String name = "";
        if (!plateA.func_190926_b()) {
            tag = Platform.openNbtData(plateA);
            name = name + tag.func_74779_i("InscribeName");
        }
        if (!plateB.func_190926_b()) {
            tag = Platform.openNbtData(plateB);
            name = name + " " + tag.func_74779_i("InscribeName");
        }
        ItemStack startingItem = input.func_77946_l();
        ItemStack renamedItem = input.func_77946_l();
        NBTTagCompound tag2 = Platform.openNbtData(renamedItem);
        NBTTagCompound display = tag2.func_74775_l("display");
        tag2.func_74782_a("display", (NBTBase)display);
        if (name.length() > 0) {
            display.func_74778_a("Name", name);
        } else {
            display.func_82580_o("Name");
        }
        ArrayList inputs = Lists.newArrayList((Object[])new ItemStack[]{startingItem});
        InscriberProcessType type = InscriberProcessType.INSCRIBE;
        IInscriberRecipeBuilder builder = AEApi.instance().registries().inscriber().builder();
        builder.withInputs(inputs).withOutput(renamedItem).withProcessType(type);
        if (!plateA.func_190926_b()) {
            builder.withTopOptional(plateA);
        }
        if (!plateB.func_190926_b()) {
            builder.withBottomOptional(plateB);
        }
        return builder.build();
    }

    private class ItemHandlerFilter
    implements IAEItemFilter {
        private ItemHandlerFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            if (TileInscriber.this.isSmash()) {
                return false;
            }
            return inv == TileInscriber.this.topItemHandler || inv == TileInscriber.this.bottomItemHandler || slot == 1;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            if (slot == 1) {
                return false;
            }
            if (TileInscriber.this.isSmash()) {
                return false;
            }
            if (inv == TileInscriber.this.topItemHandler || inv == TileInscriber.this.bottomItemHandler) {
                if (AEApi.instance().definitions().materials().namePress().isSameAs(stack)) {
                    return true;
                }
                for (ItemStack optionals : AEApi.instance().registries().inscriber().getOptionals()) {
                    if (!Platform.itemComparisons().isSameItem(stack, optionals)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

