/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.parts.automation.PlaneBakedModel;
import appeng.parts.automation.PlaneConnections;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class PlaneModel
implements IModel {
    private final ResourceLocation frontTexture;
    private final ResourceLocation sidesTexture;
    private final ResourceLocation backTexture;
    private final PlaneConnections connections;

    public PlaneModel(ResourceLocation frontTexture, ResourceLocation sidesTexture, ResourceLocation backTexture, PlaneConnections connections) {
        this.frontTexture = frontTexture;
        this.sidesTexture = sidesTexture;
        this.backTexture = backTexture;
        this.connections = connections;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Lists.newArrayList((Object[])new ResourceLocation[]{this.frontTexture, this.sidesTexture, this.backTexture});
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite frontSprite = bakedTextureGetter.apply(this.frontTexture);
        TextureAtlasSprite sidesSprite = bakedTextureGetter.apply(this.sidesTexture);
        TextureAtlasSprite backSprite = bakedTextureGetter.apply(this.backTexture);
        return new PlaneBakedModel(format, frontSprite, sidesSprite, backSprite, this.connections);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

