/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.minecraft;

import com.enderio.core.common.NBTAction;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.endercore.HandleNNList;
import info.loenwind.autosave.handlers.java.HandleArrayList;
import java.lang.reflect.Field;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandleItemStack
implements IHandler<ItemStack> {
    @Override
    public boolean canHandle(Class<?> clazz) {
        return ItemStack.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull ItemStack object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (Prep.isInvalid(object)) {
            nbt.func_74757_a(name + "+", true);
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            object.func_77955_b(tag);
            nbt.func_74782_a(name, (NBTBase)tag);
        }
        return true;
    }

    @Override
    public ItemStack read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable ItemStack object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            return new ItemStack(tag);
        }
        if (nbt.func_74764_b(name + "+")) {
            return Prep.getEmpty();
        }
        return object;
    }

    public static class HandleItemStackNNList
    extends HandleNNList<ItemStack> {
        public HandleItemStackNNList() {
            super(new HandleItemStack());
        }

        @Override
        @Nonnull
        protected ItemStack makeEmptyValueObject() {
            return Prep.getEmpty();
        }
    }

    public static class HandleItemStackArrayList
    extends HandleArrayList<ItemStack> {
        public HandleItemStackArrayList() {
            super(new HandleItemStack());
        }

        @Override
        @Nonnull
        protected ItemStack makeEmptyValueObject() {
            return Prep.getEmpty();
        }
    }
}

