/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import com.enderio.core.common.NBTAction;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class HandleAbstractMap<K, V>
implements IHandler<Map<K, V>> {
    private final IHandler<K> keyHandler;
    private final IHandler<V> valueHandler;

    protected HandleAbstractMap(IHandler<K> keyHandler, IHandler<V> valueHandler) {
        this.keyHandler = keyHandler;
        this.valueHandler = valueHandler;
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull Map<K, V> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagList tag = new NBTTagList();
        for (Map.Entry<K, V> e : object.entrySet()) {
            NBTTagCompound etag = new NBTTagCompound();
            K key = e.getKey();
            if (key != null) {
                this.keyHandler.store(registry, phase, etag, "key", key);
            } else {
                etag.func_74757_a("key-", true);
            }
            V val = e.getValue();
            if (val != null) {
                this.valueHandler.store(registry, phase, etag, "val", val);
            } else {
                etag.func_74757_a("val-", true);
            }
            tag.func_74742_a((NBTBase)etag);
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    public Map<K, V> read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable Map<K, V> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = this.createMap();
            } else {
                object.clear();
            }
            NBTTagList tag = nbt.func_150295_c(name, 10);
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound etag = tag.func_150305_b(i);
                Object key = etag.func_74767_n("key-") ? null : this.keyHandler.read(registry, phase, etag, field, "key", null);
                Object val = etag.func_74767_n("val-") ? null : this.valueHandler.read(registry, phase, etag, field, "val", null);
                object.put(key, val);
            }
        }
        return object;
    }

    @Nonnull
    protected abstract Map<K, V> createMap();
}

