/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import com.enderio.core.common.NBTAction;
import com.enderio.core.common.util.NullHelper;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandleAbstractEnumMap<K extends Enum<K>, V>
implements IHandler<EnumMap<K, V>> {
    private final Class<K> enumClass;
    private final K[] enumValues;
    private final IHandler<V> valueHandler;

    protected HandleAbstractEnumMap(Class<K> enumClass, IHandler<V> valueHandler) {
        this.enumClass = enumClass;
        this.enumValues = (Enum[])enumClass.getEnumConstants();
        this.valueHandler = valueHandler;
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull EnumMap<K, V> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound tag = new NBTTagCompound();
        for (K key : this.enumValues) {
            V val = object.get(key);
            String keystr = (String)NullHelper.notnullJ((Object)Integer.toString(((Enum)key).ordinal()), (String)"Integer.toString is null");
            if (val != null) {
                this.valueHandler.store(registry, phase, tag, keystr, val);
                continue;
            }
            tag.func_74757_a(keystr + "-", true);
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    public EnumMap<K, V> read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable EnumMap<K, V> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = this.makeMap();
            }
            NBTTagCompound tag = nbt.func_74775_l(name);
            for (K key : this.enumValues) {
                String keystr = (String)NullHelper.notnullJ((Object)Integer.toString(((Enum)key).ordinal()), (String)"Integer.toString is null");
                if (tag.func_74767_n(keystr + "-")) continue;
                object.put(key, (Object)this.valueHandler.read(registry, phase, tag, null, keystr, null));
            }
        }
        return object;
    }

    @Nonnull
    protected EnumMap<K, V> makeMap() {
        return new EnumMap(this.enumClass);
    }
}

