/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import com.enderio.core.common.NBTAction;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.machine.modes.IoMode;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class HandleAbstractEnum2EnumMap<K extends Enum<K>, V extends Enum<V>>
implements IHandler<EnumMap<K, V>> {
    private final Class<K> keyClass;
    private final K[] keys;
    private final V[] vals;
    private final int valspace;

    public HandleAbstractEnum2EnumMap(Class<K> keyClass, Class<V> valClass) {
        this.keyClass = keyClass;
        this.keys = (Enum[])keyClass.getEnumConstants();
        this.vals = (Enum[])valClass.getEnumConstants();
        this.valspace = Integer.numberOfTrailingZeros(Integer.highestOneBit(this.vals.length + 1)) + 1;
        if (this.keys.length * this.valspace > 64) {
            throw new IllegalArgumentException("Enums " + keyClass + " and " + valClass + " cannot be used, as they have too many combinations.");
        }
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull EnumMap<K, V> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        long value = 0L;
        for (K key : this.keys) {
            long subvalue = 0L;
            if (object.containsKey(key)) {
                subvalue = ((Enum)object.get(key)).ordinal() + 1;
            }
            value |= subvalue << ((Enum)key).ordinal() * this.valspace;
        }
        nbt.func_74783_a(name, new int[]{this.valspace, (int)(value >>> 32), (int)(value & 0xFFFFFFFFFFFFFFFFL)});
        return true;
    }

    @Override
    public EnumMap<K, V> read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable EnumMap<K, V> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            int[] raw;
            if (object == null) {
                object = new EnumMap(this.keyClass);
            }
            if ((raw = nbt.func_74759_k(name)).length == 0) {
                long value = nbt.func_74763_f(name);
                for (K key : this.keys) {
                    long subvalue = value >>> ((Enum)key).ordinal() * 8 & 0xFFL;
                    if (subvalue > 0L && subvalue < (long)IoMode.values().length) {
                        object.put(key, this.vals[(int)subvalue]);
                        continue;
                    }
                    object.remove(key);
                }
                return object;
            }
            int space = raw[0];
            int mask = (1 << space) - 1;
            long value = (long)raw[1] << 32 | (long)raw[2];
            for (K key : this.keys) {
                long subvalue = value >>> ((Enum)key).ordinal() * space & (long)mask;
                if (subvalue > 0L && subvalue <= (long)this.vals.length) {
                    object.put(key, this.vals[(int)subvalue - 1]);
                    continue;
                }
                if (subvalue == 0L) {
                    object.remove(key);
                    continue;
                }
                Log.error("Found invalid map value when parsing enum2enum map! Data: %s   Field: %s", nbt, field);
                Thread.dumpStack();
            }
        }
        return object;
    }
}

