/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import com.enderio.core.common.NBTAction;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class HandleAbstractCollection<E, C extends Collection<E>>
implements IHandler<C> {
    private final IHandler<E> elemHandler;

    protected HandleAbstractCollection(IHandler<E> elemHandler) {
        this.elemHandler = elemHandler;
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull C object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("size", object.size());
        int i = 0;
        for (Object elem : object) {
            if (elem != null) {
                this.elemHandler.store(registry, phase, tag, i + "", elem);
            }
            ++i;
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    public C read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable C object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = this.makeCollection();
            } else {
                object.clear();
            }
            NBTTagCompound tag = nbt.func_74775_l(name);
            int size = tag.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                if (tag.func_74764_b(i + "")) {
                    object.add(this.elemHandler.read(registry, phase, tag, null, i + "", this.makeEmptyValueObject()));
                    continue;
                }
                object.add(this.makeEmptyValueObject());
            }
        }
        return object;
    }

    @Nonnull
    protected abstract C makeCollection();

    @Nullable
    protected E makeEmptyValueObject() {
        return null;
    }
}

