/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.monitor;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.button.InvisibleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.GuiMachineBase;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.powertools.init.PowerToolObject;
import crazypants.enderio.powertools.lang.Lang;
import crazypants.enderio.powertools.machine.capbank.BlockItemCapBank;
import crazypants.enderio.powertools.machine.monitor.ContainerPowerMonitor;
import crazypants.enderio.powertools.machine.monitor.IPowerMonitorRemoteExec;
import crazypants.enderio.powertools.machine.monitor.StatCollector;
import crazypants.enderio.powertools.machine.monitor.TilePowerMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiPowerMonitor
extends GuiMachineBase<TilePowerMonitor>
implements IPowerMonitorRemoteExec.GUI {
    protected Tab tab = Tab.GRAPH;
    protected int timebase = 2;
    protected int timebaseOffset = 0;
    protected InvisibleButton plus = new InvisibleButton((IGuiScreen)this, 1, 154, 28);
    protected InvisibleButton minus;
    private CheckBox engineControlEnabled;
    private TextFieldEnder engineControlStart;
    private TextFieldEnder engineControlStop;
    private boolean engineControlEnabled_value;
    private String engineControlStart_value = null;
    private String engineControlStop_value;
    private GuiToolTip tooltipConduitStorage;
    private GuiToolTip tooltipCapacitorBankStorage;
    private GuiToolTip tooltipMachineBuffers;
    private GuiToolTip tooltipAverageOutput;
    private GuiToolTip tooltipAverageInput;
    private long lastTick = 0L;
    private static final int TEXT_MARGIN_TOP = 7;
    private static final int TEXT_MARGIN_LEFT = 7;
    private static final int TEXT_WIDTH = 162;
    private static final int LINE_Y_OFFSET = 18;
    private static final int TEXT_X_OFFSET = 18;
    private static final int TEXT_Y_OFFSET = 4;
    private static final int CONTROL_LF_PX = 16;

    public GuiPowerMonitor(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull TilePowerMonitor te) {
        super(te, (Container)new ContainerPowerMonitor(par1InventoryPlayer, te), "pmon", "pmon2");
        this.plus.setToolTip(new String[]{"+"});
        this.minus = new InvisibleButton((IGuiScreen)this, 2, 154, 52);
        this.minus.setToolTip(new String[]{"-"});
        if (!te.isAdvanced()) {
            this.tab = Tab.STAT;
        }
        this.engineControlEnabled = new CheckBox((IGuiScreen)this, 4, 0, 0);
        this.engineControlEnabled.setSelectedToolTip(new String[]{Lang.GUI_ENABLED.get()});
        this.engineControlEnabled.setUnselectedToolTip(new String[]{Lang.GUI_DISABLED.get()});
        this.engineControlStart = new TextFieldEnder(this.getFontRenderer(), 0, 0, 28, 14);
        this.engineControlStart.func_146205_d(true);
        this.engineControlStart.func_146203_f(3);
        this.textFields.add((Object)this.engineControlStart);
        this.engineControlStop = new TextFieldEnder(this.getFontRenderer(), 0, 0, 28, 14);
        this.engineControlStop.func_146205_d(true);
        this.engineControlStop.func_146203_f(3);
        this.textFields.add((Object)this.engineControlStop);
        this.tooltipConduitStorage = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{Lang.GUI_POWER_MONITOR_CONDUIT_STORAGE.get()});
        this.addToolTip(this.tooltipConduitStorage);
        this.tooltipCapacitorBankStorage = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{Lang.GUI_POWER_MONITOR_CAPBANK_STORAGE.get()});
        this.addToolTip(this.tooltipCapacitorBankStorage);
        this.tooltipMachineBuffers = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{Lang.GUI_POWER_MONITOR_MACHINE_BUFFER.get()});
        this.addToolTip(this.tooltipMachineBuffers);
        this.tooltipAverageOutput = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{Lang.GUI_POWER_MONITOR_AVERAGE_OUTPUT.get()});
        this.addToolTip(this.tooltipAverageOutput);
        this.tooltipAverageInput = new GuiToolTip(new Rectangle(0, 0, 0, 0), new String[]{Lang.GUI_POWER_MONITOR_AVERAGE_INPUT.get()});
        this.addToolTip(this.tooltipAverageInput);
        this.addDrawingElement(new PowerBar(te, this, 7, 10, 4, 66){

            @Override
            public void drawGuiContainerBackgroundLayer(float partialTicks, int par2, int par3) {
                if (GuiPowerMonitor.this.tab == Tab.GRAPH) {
                    super.drawGuiContainerBackgroundLayer(partialTicks, par2, par3);
                }
            }
        });
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneButton.field_146125_m = false;
        this.configB.field_146125_m = false;
        this.plus.onGuiInit();
        this.minus.onGuiInit();
        this.engineControlEnabled.onGuiInit();
    }

    protected void updateVisibility() {
        switch (this.tab) {
            case GRAPH: {
                if (!((TilePowerMonitor)this.getTileEntity()).isAdvanced()) {
                    this.tab = Tab.STAT;
                    this.updateVisibility();
                    return;
                }
                this.plus.field_146124_l = this.timebase < 6;
                this.minus.field_146124_l = this.timebase > 0;
                this.engineControlEnabled.field_146125_m = false;
                this.engineControlStart.func_146189_e(false);
                this.engineControlStop.func_146189_e(false);
                this.tooltipConduitStorage.setIsVisible(false);
                this.tooltipCapacitorBankStorage.setIsVisible(false);
                this.tooltipMachineBuffers.setIsVisible(false);
                this.tooltipAverageOutput.setIsVisible(false);
                this.tooltipAverageInput.setIsVisible(false);
                break;
            }
            case STAT: {
                this.minus.field_146124_l = false;
                this.plus.field_146124_l = false;
                this.engineControlEnabled.field_146125_m = false;
                this.engineControlStart.func_146189_e(false);
                this.engineControlStop.func_146189_e(false);
                this.tooltipConduitStorage.setIsVisible(true);
                this.tooltipCapacitorBankStorage.setIsVisible(true);
                this.tooltipMachineBuffers.setIsVisible(true);
                this.tooltipAverageOutput.setIsVisible(true);
                this.tooltipAverageInput.setIsVisible(true);
                break;
            }
            case CONTROL: {
                this.minus.field_146124_l = false;
                this.plus.field_146124_l = false;
                this.engineControlEnabled.field_146125_m = true;
                this.engineControlStart.func_146189_e(true);
                this.engineControlStop.func_146189_e(true);
                this.tooltipConduitStorage.setIsVisible(false);
                this.tooltipCapacitorBankStorage.setIsVisible(false);
                this.tooltipMachineBuffers.setIsVisible(false);
                this.tooltipAverageOutput.setIsVisible(false);
                this.tooltipAverageInput.setIsVisible(false);
                if (this.engineControlStart_value == null) {
                    this.engineControlEnabled_value = ((TilePowerMonitor)this.getTileEntity()).isEngineControlEnabled();
                    this.engineControlEnabled.setSelected(this.engineControlEnabled_value);
                    this.engineControlStart_value = "" + (int)(((TilePowerMonitor)this.getTileEntity()).getStartLevel() * 100.0f);
                    this.engineControlStart.func_146180_a(this.engineControlStart_value);
                    this.engineControlStop_value = "" + (int)(((TilePowerMonitor)this.getTileEntity()).getStopLevel() * 100.0f);
                    this.engineControlStop.func_146180_a(this.engineControlStop_value);
                }
                if (this.engineControlEnabled_value != this.engineControlEnabled.isSelected() || !this.engineControlStart_value.equals(this.engineControlStart.func_146179_b()) || !this.engineControlStop_value.equals(this.engineControlStop.func_146179_b())) {
                    this.doSetConfig((TilePowerMonitor)this.getTileEntity(), this.engineControlEnabled.isSelected(), (float)this.getInt((GuiTextField)this.engineControlStart) / 100.0f, (float)this.getInt((GuiTextField)this.engineControlStop) / 100.0f);
                }
                if (this.engineControlEnabled_value == ((TilePowerMonitor)this.getTileEntity()).isEngineControlEnabled() && this.engineControlStart_value.equals("" + (int)(((TilePowerMonitor)this.getTileEntity()).getStartLevel() * 100.0f)) && this.engineControlStop_value.equals("" + (int)(((TilePowerMonitor)this.getTileEntity()).getStopLevel() * 100.0f))) break;
                this.engineControlEnabled_value = ((TilePowerMonitor)this.getTileEntity()).isEngineControlEnabled();
                this.engineControlEnabled.setSelected(this.engineControlEnabled_value);
                this.engineControlStart_value = "" + (int)(((TilePowerMonitor)this.getTileEntity()).getStartLevel() * 100.0f);
                this.engineControlStart.func_146180_a(this.engineControlStart_value);
                this.engineControlStop_value = "" + (int)(((TilePowerMonitor)this.getTileEntity()).getStopLevel() * 100.0f);
                this.engineControlStop.func_146180_a(this.engineControlStop_value);
            }
        }
    }

    protected void func_146284_a(@Nonnull GuiButton btn) {
        if (btn == this.plus) {
            if (this.timebase >= 6) {
                return;
            }
            ++this.timebase;
            this.timebaseOffset -= 16;
        } else if (btn == this.minus) {
            if (this.timebase <= 0) {
                return;
            }
            --this.timebase;
            this.timebaseOffset += 16;
        }
    }

    @Override
    protected boolean doSwitchTab(int newTab) {
        if (this.tab.tabNo != newTab) {
            for (Tab drawTab : Tab.values()) {
                if (newTab != drawTab.tabNo) continue;
                this.tab = drawTab;
                return true;
            }
        }
        return super.doSwitchTab(newTab);
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    private void drawTimebase(int x, int y) {
        int u = 200;
        int v = this.timebase * 16 + this.timebaseOffset;
        int w = 18;
        int h = 16;
        if (v < 0) {
            v = 0;
        } else if (v > 96) {
            v = 96;
        }
        this.func_73729_b(x, y, u, v, w, h);
        if (this.lastTick != EnderIO.proxy.getTickCount()) {
            this.lastTick = EnderIO.proxy.getTickCount();
            if (this.timebaseOffset < 0) {
                this.timebaseOffset += 1 - this.timebaseOffset / 8;
            } else if (this.timebaseOffset > 0) {
                this.timebaseOffset -= 1 + this.timebaseOffset / 8;
            }
        }
    }

    private void drawGraph(int x, int y) {
        StatCollector stat = ((TilePowerMonitor)this.getTileEntity()).getStatCollector(this.timebase);
        int[][] values = stat.getValues();
        for (int i = 0; i < 100; ++i) {
            int min = values[0][i];
            int max = values[1][i];
            this.func_73729_b(x + i, y + 63 - max, 220, 63 - max, 1, max - min + 1);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.updateVisibility();
        switch (this.tab) {
            case GRAPH: {
                this.bindGuiTexture(0);
                this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
                this.drawTimebase(sx + 149, sy + 35);
                this.drawGraph(sx + 48, sy + 11);
                break;
            }
            case STAT: {
                this.bindGuiTexture(1);
                this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
                this.drawStats(sx, sy);
                this.bindGuiTexture(1);
                break;
            }
            case CONTROL: {
                this.bindGuiTexture(1);
                this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
                this.drawControls(sx, sy);
                this.bindGuiTexture(1);
            }
        }
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.startTabs();
        for (Tab drawTab : Tab.values()) {
            if (drawTab == Tab.GRAPH && !((TilePowerMonitor)this.getTileEntity()).isAdvanced()) continue;
            this.renderStdTab(sx, sy, drawTab.tabNo, drawTab.itemStack, drawTab == this.tab);
        }
    }

    private void drawControls(int sx, int sy) {
        FontRenderer fr = this.getFontRenderer();
        int textColor = ColorUtil.getRGB((Color)(this.engineControlEnabled.isSelected() ? Color.black : Color.darkGray));
        int x0 = sx + 7;
        int y0 = sy + 7;
        String engineTxt1 = Lang.GUI_POWER_MONITOR_ENGINE_1.get().trim();
        String engineTxt2 = Lang.GUI_POWER_MONITOR_ENGINE_2.get().trim();
        String engineTxt3 = Lang.GUI_POWER_MONITOR_ENGINE_3.get().trim();
        String engineTxt4 = Lang.GUI_POWER_MONITOR_ENGINE_4.get().trim();
        String engineTxt5 = Lang.GUI_POWER_MONITOR_ENGINE_5.get().trim();
        ArrayList<Object> elems = new ArrayList<Object>();
        elems.add(this.engineControlEnabled);
        elems.addAll(Arrays.asList(engineTxt1.split("(\\s+)")));
        elems.addAll(Arrays.asList(engineTxt2.split("(\\s+)")));
        elems.add(this.engineControlStart);
        elems.addAll(Arrays.asList(engineTxt3.split("(\\s+)")));
        elems.addAll(Arrays.asList(engineTxt4.split("(\\s+)")));
        elems.addAll(Arrays.asList(engineTxt5.split("(\\s+)")));
        elems.add(this.engineControlStop);
        elems.addAll(Arrays.asList(engineTxt3.split("(\\s+)")));
        int x = 0;
        int y = 0;
        for (Object e : elems) {
            int elemWidth = 0;
            if (e instanceof String) {
                elemWidth = fr.func_78256_a((String)e);
            } else if (e instanceof CheckBox) {
                elemWidth = ((CheckBox)e).field_146120_f;
            } else if (e instanceof TextFieldEnder) {
                elemWidth = ((TextFieldEnder)e).field_146218_h;
            }
            if (x + elemWidth > 162) {
                x = 0;
                y += 16;
                if (" ".equals(e)) continue;
            }
            if (e instanceof String) {
                fr.func_78276_b((String)e, x0 + x, y0 + y + 4, textColor);
            } else if (e instanceof CheckBox) {
                ((CheckBox)e).field_146128_h = x0 + x;
                ((CheckBox)e).field_146129_i = y0 + y;
            } else if (e instanceof TextFieldEnder) {
                ((TextFieldEnder)e).field_146209_f = x0 + x;
                ((TextFieldEnder)e).field_146210_g = y0 + y;
            }
            x += elemWidth + fr.func_78256_a(" ");
        }
    }

    private void drawStats(int sx, int sy) {
        FontRenderer fr = this.getFontRenderer();
        int valuesCol = ColorUtil.getRGB((Color)Color.black);
        int errorCol = ColorUtil.getRGB((Color)Color.red);
        int x = sx + 7;
        int y = sy + 7;
        TilePowerMonitor.StatData statData = ((TilePowerMonitor)this.getTileEntity()).getStatData();
        if (statData == null || statData.maxPowerInConduits == 0) {
            fr.func_78279_b(Lang.GUI_POWER_MONITOR_NO_NETWORK_ERROR.get(), x, y, 162, errorCol);
            return;
        }
        RenderHelper.func_74520_c();
        this.field_146296_j.func_175042_a(new ItemStack(ConduitObject.item_power_conduit.getItemNN(), 1, 2), x, y);
        this.tooltipConduitStorage.setBounds(new Rectangle(7, 7, 162, 16));
        ItemStack capBankStack = new ItemStack(PowerToolObject.block_cap_bank.getBlockNN(), 1, 3);
        if (statData.maxPowerInCapBanks > 0L) {
            BlockItemCapBank.setStoredEnergyForItem(capBankStack, (int)((double)((BlockItemCapBank)capBankStack.func_77973_b()).getMaxEnergyStored(capBankStack) * ((double)statData.powerInCapBanks / (double)statData.maxPowerInCapBanks)));
        }
        this.field_146296_j.func_175042_a(capBankStack, x, y + 18);
        this.tooltipCapacitorBankStorage.setBounds(new Rectangle(7, 25, 162, 16));
        Block icon = Blocks.field_150460_al;
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation("enderio", "block_alloy_smelter"))) {
            icon = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("enderio", "block_alloy_smelter"));
        }
        this.field_146296_j.func_175042_a(new ItemStack(icon), x, y + 54);
        this.tooltipMachineBuffers.setBounds(new Rectangle(7, 61, 162, 16));
        RenderHelper.func_74518_a();
        this.bindGuiTexture(1);
        this.func_73729_b(x, y + 36, 180, 31, 16, 16);
        this.tooltipAverageOutput.setBounds(new Rectangle(7, 43, 81, 16));
        this.func_73729_b(x + 81, y + 36, 196, 31, 16, 16);
        this.tooltipAverageInput.setBounds(new Rectangle(88, 43, 81, 16));
        String s = LangPower.RF(statData.powerInConduits, statData.maxPowerInConduits);
        fr.func_175065_a(s, (float)(x + 18), (float)(y + 4), valuesCol, false);
        s = LangPower.RF(statData.powerInCapBanks, statData.maxPowerInCapBanks);
        fr.func_175065_a(s, (float)(x + 18), (float)(y + 4 + 18), valuesCol, false);
        s = LangPower.RF(statData.powerInMachines, statData.maxPowerInMachines);
        fr.func_175065_a(s, (float)(x + 18), (float)(y + 4 + 54), valuesCol, false);
        s = LangPower.RFt(statData.aveRfSent);
        fr.func_175065_a(s, (float)(x + 18), (float)(y + 4 + 36), valuesCol, false);
        s = LangPower.RFt(statData.aveRfReceived);
        fr.func_175065_a(s, (float)(x + 18 + 81), (float)(y + 4 + 36), valuesCol, false);
    }

    private int getInt(GuiTextField tf) {
        try {
            int val = Integer.parseInt(tf.func_146179_b());
            if (val >= 0 && val <= 100) {
                return val;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static enum Tab {
        GRAPH(2, new ItemStack(PowerToolObject.block_advanced_power_monitor.getBlockNN())),
        STAT(0, new ItemStack(PowerToolObject.block_power_monitor.getBlockNN())),
        CONTROL(1, new ItemStack(Items.field_151137_ax));

        int tabNo;
        @Nonnull
        ItemStack itemStack;

        private Tab(int tabNo, ItemStack itemStack) {
            this.tabNo = tabNo;
            this.itemStack = itemStack;
        }
    }
}

