/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.gauge;

import com.enderio.core.client.render.ManagedTESR;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.powertools.init.PowerToolObject;
import crazypants.enderio.powertools.machine.capbank.render.FillGaugeBakery;
import crazypants.enderio.powertools.machine.gauge.BlockGauge;
import crazypants.enderio.powertools.machine.gauge.TileGauge;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TESRGauge
extends ManagedTESR<TileGauge> {
    public TESRGauge() {
        super(PowerToolObject.block_gauge.getBlock());
    }

    protected void renderTileEntity(@Nonnull TileGauge te, @Nonnull IBlockState blockState, float partialTicks, int destroyStage) {
        RenderHelper.func_74519_b();
        World world = te.func_145831_w();
        Map<EnumFacing, IPowerInterface> sides = BlockGauge.getDisplays((IBlockAccess)world, te.func_174877_v());
        if (!sides.isEmpty()) {
            for (Map.Entry<EnumFacing, IPowerInterface> side : sides.entrySet()) {
                float ratio;
                IPowerInterface eh = side.getValue();
                EnumFacing face = side.getKey().func_176734_d();
                int energyStored = eh.getEnergyStored();
                int maxEnergyStored = eh.getMaxEnergyStored();
                float f = ratio = maxEnergyStored > 0 ? (float)energyStored / (float)maxEnergyStored : 0.0f;
                FillGaugeBakery bakery = new FillGaugeBakery((IBlockAccess)world, te.func_174877_v().func_177972_a((EnumFacing)NullHelper.first((Object[])new EnumFacing[]{side.getKey(), EnumFacing.DOWN})), face, BlockGauge.gaugeIcon.get(TextureAtlasSprite.class), ratio);
                if (!bakery.canRender()) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)(-face.func_82601_c()), (double)(-face.func_96559_d()), (double)(-face.func_82599_e()));
                bakery.render();
                GL11.glPopMatrix();
            }
        } else {
            double v = (float)(EnderIO.proxy.getTickCount() % 100L) + partialTicks;
            if (v > 50.0) {
                v = 100.0 - v;
            }
            double ratio = v / 50.0;
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                FillGaugeBakery bakery = new FillGaugeBakery((IBlockAccess)world, te.func_174877_v().func_177972_a(face.func_176734_d()), face, BlockGauge.gaugeIcon.get(TextureAtlasSprite.class), ratio);
                if (!bakery.canRender()) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)(-face.func_82601_c()), (double)(-face.func_96559_d()), (double)(-face.func_82599_e()));
                bakery.render();
                GL11.glPopMatrix();
            }
        }
    }
}

