/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.capacitor;

import crazypants.enderio.base.capacitor.CapacitorKeyHelper;
import crazypants.enderio.base.capacitor.CapacitorKeyType;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.Scaler;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.powertools.EnderIOPowerTools;
import crazypants.enderio.powertools.config.Config;
import crazypants.enderio.powertools.init.PowerToolObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;

public enum CapacitorKey implements ICapacitorKey.Computable
{
    POWER_MONITOR_POWER_INTAKE(PowerToolObject.block_power_monitor, CapacitorKeyType.ENERGY_INTAKE, Scaler.Factory.FIXED_1, 10),
    POWER_MONITOR_POWER_BUFFER(PowerToolObject.block_power_monitor, CapacitorKeyType.ENERGY_BUFFER, Scaler.Factory.FIXED_1, 1000),
    POWER_MONITOR_POWER_USE(PowerToolObject.block_power_monitor, CapacitorKeyType.ENERGY_USE, Scaler.Factory.FIXED_1, 5);

    @Nonnull
    private final PowerToolObject owner;
    @Nonnull
    private final CapacitorKeyType valueType;
    @Nonnull
    private Scaler scaler;
    @Nonnull
    private final String configKey;
    @Nonnull
    private final Config.Section configSection;
    @Nonnull
    private final String configComment;
    private final int defaultBaseValue;
    private int baseValue;

    private CapacitorKey(@Nonnull PowerToolObject owner, CapacitorKeyType valueType, Scaler scaler, int defaultBaseValue) {
        this(owner, valueType, scaler, defaultBaseValue, Config.sectionCapacitor, null);
    }

    private CapacitorKey(@Nonnull PowerToolObject owner, CapacitorKeyType valueType, @Nonnull Scaler scaler, @Nullable int defaultBaseValue, Config.Section configSection, String configKey) {
        this.owner = owner;
        this.valueType = valueType;
        this.scaler = scaler;
        this.configKey = CapacitorKeyHelper.createConfigKey(this, configKey);
        this.configSection = configSection;
        this.configComment = CapacitorKeyHelper.localizeComment(EnderIOPowerTools.lang, this.configSection, this.configKey);
        this.baseValue = this.defaultBaseValue = defaultBaseValue;
    }

    @Override
    @Nonnull
    public PowerToolObject getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public CapacitorKeyType getValueType() {
        return this.valueType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    @Nonnull
    public Scaler getScaler() {
        return this.scaler;
    }

    @Override
    public void setScaler(@Nonnull Scaler scaler) {
        this.scaler = scaler;
    }

    @Override
    @Nonnull
    public String getConfigKey() {
        return this.configKey;
    }

    @Override
    @Nonnull
    public Config.Section getConfigSection() {
        return this.configSection;
    }

    @Override
    @Nonnull
    public String getConfigComment() {
        return this.configComment;
    }

    @Override
    public int getDefaultBaseValue() {
        return this.defaultBaseValue;
    }

    @Override
    public int getBaseValue() {
        return this.baseValue;
    }

    @Override
    public void setBaseValue(int baseValue) {
        this.baseValue = baseValue;
    }

    public static void processConfig(Configuration config) {
        CapacitorKeyHelper.processConfig(config, CapacitorKey.values());
    }
}

