/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.wireless;

import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.machines.machine.wireless.BlockWirelessCharger;
import crazypants.enderio.machines.machine.wireless.TileWirelessCharger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class WirelessRenderMapper
implements IRenderMapper.IBlockRenderMapper,
IRenderMapper.IItemRenderMapper.IItemStateMapper {
    @Nonnull
    public static final WirelessRenderMapper instance = new WirelessRenderMapper();

    private WirelessRenderMapper() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        TileEntity tileEntity = state.getTileEntity();
        Block block = state.func_177230_c();
        if (tileEntity instanceof TileWirelessCharger && block instanceof BlockWirelessCharger) {
            return this.render(state.getState(), world, pos, blockLayer, (TileWirelessCharger)tileEntity, (BlockWirelessCharger)block);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected List<IBlockState> render(IBlockState state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, TileWirelessCharger tileEntity, BlockWirelessCharger block) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        boolean active = tileEntity.isActive();
        if (active) {
            states.add(state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)));
        } else {
            states.add(state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT)));
        }
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ItemQuadCollector itemQuadCollector) {
        ArrayList<Pair<IBlockState, ItemStack>> states = new ArrayList<Pair<IBlockState, ItemStack>>();
        states.add(Pair.of((Object)block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON)), (Object)stack));
        return states;
    }
}

