/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.wireless;

import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.power.ILegacyPowerReceiver;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.power.wireless.IWirelessCharger;
import crazypants.enderio.base.power.wireless.WirelessChargerController;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.wireless.PacketStoredEnergy;
import crazypants.enderio.machines.network.PacketHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

@Storable
public class TileWirelessCharger
extends TileEntityEio
implements ILegacyPowerReceiver,
IWirelessCharger,
IPaintable.IPaintableTileEntity {
    @Store
    int storedEnergyRF;
    private double lastPowerUpdate = -1.0;
    private boolean registered = false;

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        WirelessChargerController.instance.deregisterCharger(this);
        this.registered = false;
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            YetaUtil.refresh((TileEntity)this);
            return;
        }
        if (!this.registered) {
            WirelessChargerController.instance.registerCharger(this);
            this.registered = true;
        }
        if (this.lastPowerUpdate == -1.0 || this.lastPowerUpdate == 0.0 && this.storedEnergyRF > 0 || this.lastPowerUpdate > 0.0 && this.storedEnergyRF == 0 || this.lastPowerUpdate != (double)this.storedEnergyRF && this.shouldDoWorkThisTick(3600)) {
            this.lastPowerUpdate = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketStoredEnergy(this), (TileEntity)this);
        }
    }

    @Override
    public boolean chargeItems(NonNullList<ItemStack> items) {
        boolean chargedItem = false;
        int available = Math.min(CapacitorKey.WIRELESS_POWER_OUTPUT.get(DefaultCapacitorData.BASIC_CAPACITOR), this.storedEnergyRF);
        int end = items.size();
        for (int i = 0; i < end && available > 0; ++i) {
            int used;
            IEnergyStorage chargable;
            ItemStack item = (ItemStack)items.get(i);
            if (item.func_190926_b() || (chargable = PowerHandlerUtil.getCapability((ICapabilityProvider)item, null)) == null || item.func_190916_E() != 1) continue;
            int max = chargable.getMaxEnergyStored();
            int cur = chargable.getEnergyStored();
            int canUse = Math.min(available, max - cur);
            if (cur >= max || (used = chargable.receiveEnergy(canUse, false)) <= 0) continue;
            this.storedEnergyRF -= used;
            chargedItem = true;
            available -= used;
        }
        return chargedItem;
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return CapacitorKey.WIRELESS_POWER_INTAKE.get(DefaultCapacitorData.BASIC_CAPACITOR);
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public int getMaxEnergyStored() {
        return CapacitorKey.WIRELESS_POWER_BUFFER.get(DefaultCapacitorData.BASIC_CAPACITOR);
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = stored;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public int takeEnergy(int max) {
        if (this.isActive()) {
            int prev = this.storedEnergyRF;
            this.storedEnergyRF = Math.max(0, this.storedEnergyRF - max);
            return prev - this.storedEnergyRF;
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(@Nonnull EnumFacing from) {
        return true;
    }

    @Override
    @Nonnull
    public World getworld() {
        return this.func_145831_w();
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    @Override
    public boolean isActive() {
        return this.getEnergyStored() > 0 && !this.isPoweredRedstone();
    }

    @Override
    @Nonnull
    public BlockPos getLocation() {
        return this.field_174879_c;
    }

    @Override
    protected void onAfterDataPacket() {
        this.updateBlock();
    }
}

