/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.wireless;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.wireless.TileWirelessCharger;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStoredEnergy
extends MessageTileEntity<TileWirelessCharger>
implements IMessage {
    private int storedEnergy;

    public PacketStoredEnergy() {
    }

    public PacketStoredEnergy(@Nonnull TileWirelessCharger ent) {
        super((TileEntity)ent);
        this.storedEnergy = ent.storedEnergyRF;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.storedEnergy);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.storedEnergy = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketStoredEnergy, IMessage> {
        public IMessage onMessage(PacketStoredEnergy message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            TileWirelessCharger te = (TileWirelessCharger)message.getTileEntity(player.field_70170_p);
            if (te != null) {
                boolean doRender = te.storedEnergyRF > 0 != message.storedEnergy > 0;
                te.storedEnergyRF = message.storedEnergy;
                if (doRender) {
                    te.onAfterDataPacket();
                }
            }
            return null;
        }
    }
}

