/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vacuum;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.NBTAction;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.util.MagnetUtil;
import com.enderio.core.common.util.NNList;
import com.google.common.base.Predicate;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.xp.ExperienceContainer;
import crazypants.enderio.machines.config.config.VacuumConfig;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

@Storable
public class TileXPVacuum
extends TileEntityEio
implements Predicate<EntityXPOrb>,
IPaintable.IPaintableTileEntity,
ITankAccess {
    private static final int IO_MB_TICK = 10000;
    @Store
    private boolean formed = false;
    private boolean formedRender = false;
    @Store(value={NBTAction.SAVE, NBTAction.ITEM})
    private final ExperienceContainer xpCon;
    private static final double speed = 0.03;
    @Nonnull
    private final NNList.Callback<EnumFacing> push_callback = new NNList.Callback<EnumFacing>(){

        public void apply(@Nonnull EnumFacing dir) {
            if (TileXPVacuum.this.xpCon.getFluidAmount() > 0 && FluidWrapper.transfer((FluidTank)TileXPVacuum.this.xpCon, (IBlockAccess)TileXPVacuum.this.field_145850_b, (BlockPos)TileXPVacuum.this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)10000) > 0) {
                TileXPVacuum.this.setTanksDirty();
            }
        }
    };

    public TileXPVacuum() {
        this.xpCon = new ExperienceContainer(Integer.MAX_VALUE);
        this.xpCon.setTileEntity((TileEntity)this);
        this.xpCon.setCanFill(!this.formed);
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            YetaUtil.refresh((TileEntity)this);
            if (this.formed != this.formedRender) {
                this.formedRender = this.formed;
                this.updateBlock();
            }
            if (this.formed) {
                this.doHoover();
            }
        } else {
            if (this.formed) {
                this.doHoover();
                if (this.xpCon.getFluidAmount() > 0) {
                    this.doPush();
                }
            } else if (this.xpCon.getFluidAmount() > 0) {
                this.formed = true;
                this.func_70296_d();
                this.updateBlock();
            }
            this.xpCon.setCanFill(!this.formed);
        }
    }

    public boolean apply(@Nullable EntityXPOrb entity) {
        return MagnetUtil.shouldAttract((BlockPos)this.func_174877_v(), (Entity)entity);
    }

    private void doHoover() {
        boolean pickUpThisTick = this.xpCon.getFluidAmount() == 0;
        for (EntityXPOrb entity : this.field_145850_b.func_175647_a(EntityXPOrb.class, (AxisAlignedBB)new BoundingBox(this.func_174877_v()).expand((double)VacuumConfig.vacuumXPRange.get().intValue()), (Predicate)this)) {
            double z;
            double y;
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u) * y + (z = (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v) * z);
            if (distance < 1.25) {
                if (!pickUpThisTick || this.field_145850_b.field_72995_K || entity.field_70128_L) continue;
                int xpValue = entity.func_70526_d();
                this.xpCon.addExperience(xpValue);
                entity.func_70106_y();
                continue;
            }
            double distScale = Math.min(1.0, Math.max(0.25, 1.0 - distance / (double)VacuumConfig.vacuumXPRange.get().intValue()));
            distScale *= distScale;
            entity.field_70159_w += x / distance * distScale * 0.03;
            entity.field_70181_x = entity.field_70163_u < (double)this.field_174879_c.func_177956_o() ? (entity.field_70181_x += y / distance * distScale * 0.03 + 0.03) : (entity.field_70181_x += y / distance * distScale * 0.03);
            entity.field_70179_y += z / distance * distScale * 0.03;
        }
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void doPush() {
        if (this.xpCon.getFluidAmount() > 0) {
            NNList.FACING.apply(this.push_callback);
        }
    }

    public boolean isFormed() {
        return this.formedRender;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (!this.formed && forFluidType != null && forFluidType.getFluid() == Fluids.XP_JUICE.getFluid()) {
            return this.xpCon;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCon};
    }

    public void setTanksDirty() {
        this.func_70296_d();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.xpCon);
        }
        return (T)super.getCapability(capability, facingIn);
    }
}

