/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad;

import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector4i;
import crazypants.enderio.machines.config.config.TelePadConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderiomachines", value={Side.CLIENT})
public class TeleportEntityRenderHandler {
    private static final Vector4i COL_TOP = new Vector4i(220, 255, 255, 0);
    private static final Vector4i COL_BOT = new Vector4i(175, 255, 255, 100);

    @SubscribeEvent
    public static void onEntityRender(RenderLivingEvent.Post<EntityLivingBase> event) {
        EntityLivingBase e = event.getEntity();
        if (e.getEntityData().func_74767_n("eio_needs_pop")) {
            GlStateManager.func_179121_F();
            e.getEntityData().func_82580_o("eio_needs_pop");
        }
        if (e.getEntityData().func_74767_n("eio:teleporting")) {
            float progress = e.getEntityData().func_74760_g("teleportprogress");
            float speed = progress * 1.2f;
            float rot = e.getEntityData().func_74760_g("eio_teleportrotation") + speed;
            e.getEntityData().func_74776_a("eio_teleportrotation", rot);
            AxisAlignedBB bb = e.func_184177_bl();
            if (NullHelper.untrust((Object)bb) == null || bb.func_72320_b() < 0.2) {
                float radius = e.field_70130_N / 2.0f;
                bb = new AxisAlignedBB((double)(-radius), 0.0, (double)(-radius), (double)radius, (double)e.field_70131_O, (double)radius).func_72317_d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
            }
            bb = bb.func_186666_e(bb.field_72337_e + 1.25 - (double)(progress / 2.0f)).func_72321_a(0.5 - (double)(progress / 5.0f), 0.0, 0.5 - (double)(progress / 5.0f));
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)1, (int)0, (int)1);
            GlStateManager.func_179118_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            GlStateManager.func_179114_b((float)(rot + Minecraft.func_71410_x().func_184121_ak() + (float)e.field_70173_aa), (float)0.0f, (float)1.0f, (float)0.0f);
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tes.func_178180_c();
            vertexBuffer.func_178969_c(-e.field_70165_t, -e.field_70163_u, -e.field_70161_v);
            vertexBuffer.func_181668_a(8, DefaultVertexFormats.field_181706_f);
            vertexBuffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181669_b(TeleportEntityRenderHandler.COL_TOP.x, TeleportEntityRenderHandler.COL_TOP.y, TeleportEntityRenderHandler.COL_TOP.z, TeleportEntityRenderHandler.COL_TOP.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181669_b(TeleportEntityRenderHandler.COL_BOT.x, TeleportEntityRenderHandler.COL_BOT.y, TeleportEntityRenderHandler.COL_BOT.z, TeleportEntityRenderHandler.COL_BOT.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181669_b(TeleportEntityRenderHandler.COL_TOP.x, TeleportEntityRenderHandler.COL_TOP.y, TeleportEntityRenderHandler.COL_TOP.z, TeleportEntityRenderHandler.COL_TOP.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181669_b(TeleportEntityRenderHandler.COL_BOT.x, TeleportEntityRenderHandler.COL_BOT.y, TeleportEntityRenderHandler.COL_BOT.z, TeleportEntityRenderHandler.COL_BOT.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181669_b(TeleportEntityRenderHandler.COL_TOP.x, TeleportEntityRenderHandler.COL_TOP.y, TeleportEntityRenderHandler.COL_TOP.z, TeleportEntityRenderHandler.COL_TOP.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181669_b(TeleportEntityRenderHandler.COL_BOT.x, TeleportEntityRenderHandler.COL_BOT.y, TeleportEntityRenderHandler.COL_BOT.z, TeleportEntityRenderHandler.COL_BOT.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181669_b(TeleportEntityRenderHandler.COL_TOP.x, TeleportEntityRenderHandler.COL_TOP.y, TeleportEntityRenderHandler.COL_TOP.z, TeleportEntityRenderHandler.COL_TOP.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181669_b(TeleportEntityRenderHandler.COL_BOT.x, TeleportEntityRenderHandler.COL_BOT.y, TeleportEntityRenderHandler.COL_BOT.z, TeleportEntityRenderHandler.COL_BOT.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181669_b(TeleportEntityRenderHandler.COL_TOP.x, TeleportEntityRenderHandler.COL_TOP.y, TeleportEntityRenderHandler.COL_TOP.z, TeleportEntityRenderHandler.COL_TOP.w).func_181675_d();
            vertexBuffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181669_b(TeleportEntityRenderHandler.COL_BOT.x, TeleportEntityRenderHandler.COL_BOT.y, TeleportEntityRenderHandler.COL_BOT.z, TeleportEntityRenderHandler.COL_BOT.w).func_181675_d();
            tes.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void onEntityRender(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (TelePadConfig.telepadShrinkEffect.get().booleanValue()) {
            NBTTagCompound entityData = event.getEntity().getEntityData();
            boolean isTarget = false;
            if (entityData.func_74767_n("eio:teleporting")) {
                isTarget = true;
                entityData.func_74768_a("eio_delay", 7);
            } else if (entityData.func_74764_b("eio_delay")) {
                int delay = entityData.func_74762_e("eio_delay") - 1;
                if (delay > 0) {
                    entityData.func_74768_a("eio_delay", delay);
                } else {
                    entityData.func_82580_o("eio_delay");
                    entityData.func_82580_o("eio_teleportrotation");
                }
                isTarget = true;
            }
            if (isTarget) {
                float progress = entityData.func_74764_b("teleportprogress") ? entityData.func_74760_g("teleportprogress") : 1.0f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                float scale = 1.0f - progress * 0.75f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
                entityData.func_74757_a("eio_needs_pop", true);
            }
        }
    }
}

