/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad;

import com.enderio.core.common.util.Util;
import crazypants.enderio.machines.machine.teleport.telepad.DialerFacing;
import crazypants.enderio.machines.machine.teleport.telepad.TileDialingDevice;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockItemDialingDevice
extends ItemBlock {
    public BlockItemDialingDevice(Block b) {
        super(b);
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        boolean result = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileDialingDevice)) {
            return result;
        }
        float dx = Math.abs(0.5f - hitX);
        float dy = Math.abs(0.5f - hitY);
        float dz = Math.abs(0.5f - hitZ);
        side = side.func_176734_d();
        DialerFacing facing = DialerFacing.DOWN_TONORTH;
        EnumFacing looking = Util.getFacingFromEntity((EntityLivingBase)player);
        switch (side) {
            case DOWN: {
                if (looking == EnumFacing.EAST) {
                    facing = DialerFacing.DOWN_TOEAST;
                    break;
                }
                if (looking == EnumFacing.WEST) {
                    facing = DialerFacing.DOWN_TOWEST;
                    break;
                }
                if (looking == EnumFacing.NORTH) {
                    facing = DialerFacing.DOWN_TONORTH;
                    break;
                }
                if (looking != EnumFacing.SOUTH) break;
                facing = DialerFacing.DOWN_TOSOUTH;
                break;
            }
            case UP: {
                if (looking == EnumFacing.EAST) {
                    facing = DialerFacing.UP_TOEAST;
                    break;
                }
                if (looking == EnumFacing.WEST) {
                    facing = DialerFacing.UP_TOWEST;
                    break;
                }
                if (looking == EnumFacing.NORTH) {
                    facing = DialerFacing.UP_TONORTH;
                    break;
                }
                if (looking != EnumFacing.SOUTH) break;
                facing = DialerFacing.UP_TOSOUTH;
                break;
            }
            case NORTH: {
                if (dx < dy) {
                    facing = (double)hitY > 0.5 ? DialerFacing.NORTH_TOUP : DialerFacing.NORTH_TODOWN;
                    break;
                }
                facing = (double)hitX > 0.5 ? DialerFacing.NORTH_TOEAST : DialerFacing.NORTH_TOWEST;
                break;
            }
            case SOUTH: {
                if (dx < dy) {
                    facing = (double)hitY > 0.5 ? DialerFacing.SOUTH_TOUP : DialerFacing.SOUTH_TODOWN;
                    break;
                }
                facing = (double)hitX > 0.5 ? DialerFacing.SOUTH_TOEAST : DialerFacing.SOUTH_TOWEST;
                break;
            }
            case WEST: {
                if (dy < dz) {
                    facing = (double)hitZ > 0.5 ? DialerFacing.WEST_TOSOUTH : DialerFacing.WEST_TONORTH;
                    break;
                }
                facing = (double)hitY > 0.5 ? DialerFacing.WEST_TOUP : DialerFacing.WEST_TODOWN;
                break;
            }
            case EAST: {
                if (dy < dz) {
                    facing = (double)hitZ > 0.5 ? DialerFacing.EAST_TOSOUTH : DialerFacing.EAST_TONORTH;
                    break;
                }
                facing = (double)hitY > 0.5 ? DialerFacing.EAST_TOUP : DialerFacing.EAST_TODOWN;
                break;
            }
            default: {
                facing = DialerFacing.DOWN_TOWEST;
            }
        }
        TileDialingDevice logicTileEntity = (TileDialingDevice)te;
        logicTileEntity.setDialerFacing(facing);
        return result;
    }
}

