/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.spawner;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.NBTAction;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.modes.EntityAction;
import crazypants.enderio.base.machine.task.PoweredTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.spawner.DummyRecipe;
import crazypants.enderio.base.recipe.spawner.PoweredSpawnerRecipeRegistry;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.SpawnerConfig;
import crazypants.enderio.machines.machine.spawner.PacketSpawnerUpdateNotification;
import crazypants.enderio.machines.machine.spawner.SpawnerNotification;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TilePoweredSpawner
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity,
IRanged,
EntityAction.Implementer,
INotifier {
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE})
    private CapturedMob capturedMob = null;
    @Store
    private boolean isSpawnMode = true;
    @Nonnull
    private final Set<SpawnerNotification> notification = EnumSet.noneOf(SpawnerNotification.class);
    private boolean sendNotification = false;
    private double mobRotation;
    private double prevMobRotation;
    private Entity cachedEntity;
    private BoundingBox bounds;
    private boolean showingRange;
    @Nonnull
    private static final Vector4f color = new Vector4f(0.94f, 0.11f, 0.11f, 0.4f);

    public TilePoweredSpawner() {
        super(new SlotDefinition(1, 1, 1), CapacitorKey.SPAWNER_POWER_INTAKE, CapacitorKey.SPAWNER_POWER_BUFFER, CapacitorKey.SPAWNER_POWER_USE);
    }

    public boolean isSpawnMode() {
        return this.isSpawnMode;
    }

    public void setSpawnMode(boolean isSpawnMode) {
        if (isSpawnMode != this.isSpawnMode) {
            this.currentTask = null;
        }
        this.isSpawnMode = isSpawnMode;
    }

    @Override
    protected void taskComplete() {
        super.taskComplete();
        if (this.hasEntity()) {
            if (this.isSpawnMode) {
                boolean spawnedOne = false;
                for (int i = 0; i < SpawnerConfig.poweredSpawnerSpawnCount.get(); ++i) {
                    if (!this.trySpawnEntity()) continue;
                    spawnedOne = true;
                }
                if (spawnedOne) {
                    this.clearNotification();
                }
            } else {
                this.clearNotification();
                if (Prep.isInvalid(this.getStackInSlot(0)) || Prep.isValid(this.getStackInSlot(1)) || !this.hasEntity()) {
                    return;
                }
                ItemStack res = this.capturedMob.toGenericStack(ModObject.itemSoulVial.getItemNN(), 1, 1);
                this.getStackInSlot(0).func_190918_g(1);
                this.setInventorySlotContents(1, res);
            }
        } else {
            this.field_145850_b.func_175655_b(this.func_174877_v(), true);
        }
        if (this.sendNotification) {
            if (this.hasNotification(SpawnerNotification.NO_LOCATION_FOUND)) {
                this.anyLocationInRange();
            }
            this.sendNotification();
        }
    }

    @Override
    public int getMaxUsage() {
        return this.getPowerUsePerTick();
    }

    @Override
    public int getPowerUsePerTick() {
        ResourceLocation entityName = this.getEntityName();
        return (int)((double)super.getPowerUsePerTick() * (entityName == null ? 0.0 : PoweredSpawnerRecipeRegistry.getInstance().getCostMultiplierFor(entityName)));
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        ResourceLocation entityName = this.getEntityName();
        return (int)((double)super.getMaxEnergyRecieved(dir) * (entityName == null ? 0.0 : PoweredSpawnerRecipeRegistry.getInstance().getCostMultiplierFor(entityName)));
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "spawner";
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b() || this.isSpawnMode) {
            return false;
        }
        if (this.slotDefinition.isInputSlot(i)) {
            return itemstack.func_77973_b() == ModObject.itemSoulVial.getItem() && !CapturedMob.containsSoul(itemstack);
        }
        return false;
    }

    @Override
    protected IMachineRecipe canStartNextTask(long nextSeed) {
        if (!this.hasEntity()) {
            this.field_145850_b.func_175655_b(this.func_174877_v(), true);
            return null;
        }
        if (this.isSpawnMode) {
            BlockPos p;
            if (SpawnerConfig.poweredSpawnerMaxPlayerDistance.get() > 0 && this.field_145850_b.func_184137_a((double)(p = this.func_174877_v()).func_177958_n() + 0.5, (double)p.func_177958_n() + 0.5, (double)p.func_177958_n() + 0.5, (double)SpawnerConfig.poweredSpawnerMaxPlayerDistance.get().intValue(), false) == null) {
                this.setNotification(SpawnerNotification.NO_PLAYER);
                return null;
            }
            this.removeNotification(SpawnerNotification.NO_PLAYER);
        } else {
            this.clearNotification();
            if (Prep.isInvalid(this.getStackInSlot(0)) || Prep.isValid(this.getStackInSlot(1))) {
                return null;
            }
        }
        return new DummyRecipe();
    }

    @Override
    protected boolean hasInputStacks() {
        return true;
    }

    @Override
    protected boolean canInsertResult(long nextSeed, @Nonnull IMachineRecipe nextRecipe) {
        return true;
    }

    @Override
    public void writeCustomNBT(@Nonnull ItemStack stack) {
        super.writeCustomNBT(stack);
        if (this.hasEntity()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            this.capturedMob.toNbt(stack.func_77978_p());
        }
    }

    double getMobRotation() {
        return this.mobRotation;
    }

    double getPrevMobRotation() {
        return this.prevMobRotation;
    }

    Entity getCachedEntity() {
        return this.cachedEntity;
    }

    @Override
    protected void updateEntityClient() {
        if (this.isActive()) {
            double x = (float)this.func_174877_v().func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
            double y = (float)this.func_174877_v().func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            double z = (float)this.func_174877_v().func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            this.prevMobRotation = this.mobRotation;
            this.mobRotation = (this.mobRotation + (double)(1000.0f / ((1.0f - this.getProgress()) * 800.0f + 200.0f))) % 360.0;
            if (this.cachedEntity == null && this.hasEntity()) {
                this.cachedEntity = this.capturedMob.getEntity(this.field_145850_b, this.field_174879_c, null, false);
                this.cachedEntity.func_70106_y();
            }
        }
        super.updateEntityClient();
    }

    @Override
    protected IPoweredTask createTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        PoweredTask res = new PoweredTask(nextRecipe, nextSeed, this.getRecipeInputs());
        int ticksDelay = this.isSpawnMode ? SpawnerConfig.poweredSpawnerMinDelayTicks.get() + (int)Math.round((double)(SpawnerConfig.poweredSpawnerMaxDelayTicks.get() - SpawnerConfig.poweredSpawnerMinDelayTicks.get()) * Math.random()) : SpawnerConfig.poweredSpawnerMaxDelayTicks.get() - (SpawnerConfig.poweredSpawnerMaxDelayTicks.get() - SpawnerConfig.poweredSpawnerMinDelayTicks.get()) / 2;
        ticksDelay = (int)((float)ticksDelay / CapacitorKey.SPAWNER_SPEEDUP.getFloat(this.getCapacitorData()));
        int powerPerTick = this.getPowerUsePerTick();
        res.setRequiredEnergy(powerPerTick * ticksDelay);
        return res;
    }

    protected boolean canSpawnEntity(EntityLiving entityliving) {
        boolean spaceClear;
        boolean bl = spaceClear = this.field_145850_b.func_72855_b(entityliving.func_174813_aQ()) && this.field_145850_b.func_184144_a((Entity)entityliving, entityliving.func_174813_aQ()).isEmpty() && (!this.field_145850_b.func_72953_d(entityliving.func_174813_aQ()) || entityliving.isCreatureType(EnumCreatureType.WATER_CREATURE, false));
        if (spaceClear && SpawnerConfig.poweredSpawnerUseVanillaSpawChecks.get().booleanValue()) {
            spaceClear = entityliving.func_70601_bi();
        }
        return spaceClear;
    }

    Entity createEntity(DifficultyInstance difficulty, boolean forceAlive) {
        Entity ent = this.capturedMob.getEntity(this.field_145850_b, this.field_174879_c, difficulty, false);
        if (forceAlive && SpawnerConfig.poweredSpawnerMaxPlayerDistance.get() <= 0 && SpawnerConfig.poweredSpawnerDespawnTimeSeconds.get() > 0 && ent instanceof EntityLiving) {
            ent.getEntityData().func_74772_a("spawnedByPoweredSpawner", this.field_145850_b.func_82737_E());
            ((EntityLiving)ent).func_110163_bv();
        }
        return ent;
    }

    protected boolean trySpawnEntity() {
        Entity entity = this.createEntity(this.field_145850_b.func_175649_E(this.func_174877_v()), true);
        if (!(entity instanceof EntityLiving)) {
            this.cleanupUnspawnedEntity(entity);
            this.setNotification(SpawnerNotification.BAD_SOUL);
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        int spawnRange = this.getRange();
        if (SpawnerConfig.poweredSpawnerMaxNearbyEntities.get() > 0) {
            int nearbyEntities = this.field_145850_b.func_175647_a(entity.getClass(), (AxisAlignedBB)this.getBounds().expand((double)spawnRange, 2.0, (double)spawnRange), EntitySelectors.field_94557_a).size();
            if (nearbyEntities >= SpawnerConfig.poweredSpawnerMaxNearbyEntities.get()) {
                this.cleanupUnspawnedEntity(entity);
                this.setNotification(SpawnerNotification.AREA_FULL);
                return false;
            }
            this.removeNotification(SpawnerNotification.AREA_FULL);
        }
        for (int i = 0; i < SpawnerConfig.poweredSpawnerMaxSpawnTries.get(); ++i) {
            double x = (double)this.func_174877_v().func_177958_n() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange;
            double y = this.func_174877_v().func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3) - 1;
            double z = (double)this.func_174877_v().func_177952_p() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange;
            entity.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.canSpawnEntity(entityliving)) continue;
            this.field_145850_b.func_72838_d((Entity)entityliving);
            this.field_145850_b.func_175718_b(2004, this.func_174877_v(), 0);
            entityliving.func_70656_aK();
            Entity ridingEntity = entity.func_184187_bx();
            if (ridingEntity != null) {
                ridingEntity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
            }
            for (Entity passenger : entity.func_184188_bt()) {
                passenger.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
            }
            return true;
        }
        this.cleanupUnspawnedEntity(entity);
        this.setNotification(SpawnerNotification.NO_LOCATION_FOUND);
        return false;
    }

    private void cleanupUnspawnedEntity(Entity entity) {
        if (entity != null) {
            Entity ridingEntity = entity.func_184187_bx();
            if (ridingEntity != null) {
                ridingEntity.func_70106_y();
            }
            for (Entity passenger : entity.func_184188_bt()) {
                passenger.func_70106_y();
            }
        }
    }

    protected boolean anyLocationInRange() {
        Entity entity = this.createEntity(this.field_145850_b.func_175649_E(this.func_174877_v()), true);
        if (!(entity instanceof EntityLiving)) {
            this.cleanupUnspawnedEntity(entity);
            this.setNotification(SpawnerNotification.BAD_SOUL);
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        int spawnRange = SpawnerConfig.poweredSpawnerSpawnRange.get();
        int minxi = MathHelper.func_76128_c((double)((double)this.func_174877_v().func_177958_n() + (0.0 - Math.nextAfter(1.0, 0.0)) * (double)spawnRange));
        int maxxi = MathHelper.func_76128_c((double)((double)this.func_174877_v().func_177958_n() + (Math.nextAfter(1.0, 0.0) - 0.0) * (double)spawnRange));
        int minyi = this.func_174877_v().func_177956_o() + 0 - 1;
        int maxyi = this.func_174877_v().func_177956_o() + 2 - 1;
        int minzi = MathHelper.func_76128_c((double)((double)this.func_174877_v().func_177952_p() + (0.0 - Math.nextAfter(1.0, 0.0)) * (double)spawnRange));
        int maxzi = MathHelper.func_76128_c((double)((double)this.func_174877_v().func_177952_p() + (Math.nextAfter(1.0, 0.0) - 0.0) * (double)spawnRange));
        for (int x = minxi; x <= maxxi; ++x) {
            for (int y = minyi; y <= maxyi; ++y) {
                for (int z = minzi; z <= maxzi; ++z) {
                    entityliving.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, 0.0f, 0.0f);
                    if (!this.canSpawnEntity(entityliving)) continue;
                    this.cleanupUnspawnedEntity(entity);
                    this.removeNotification(SpawnerNotification.NO_LOCATION_AT_ALL);
                    return true;
                }
            }
        }
        this.cleanupUnspawnedEntity(entity);
        this.setNotification(SpawnerNotification.NO_LOCATION_AT_ALL);
        return false;
    }

    public ResourceLocation getEntityName() {
        return this.capturedMob != null ? this.capturedMob.getEntityName() : null;
    }

    public CapturedMob getEntity() {
        return this.capturedMob;
    }

    public boolean hasEntity() {
        return this.capturedMob != null;
    }

    @Override
    public void readCustomNBT(@Nonnull ItemStack stack) {
        super.readCustomNBT(stack);
        this.capturedMob = CapturedMob.create(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TilePoweredSpawner>(this, color));
        }
    }

    @Override
    public void onCapacitorDataChange() {
        super.onCapacitorDataChange();
        this.bounds = null;
    }

    @Override
    @Nonnull
    public BoundingBox getBounds() {
        if (this.isSpawnMode) {
            Entity ent;
            if (this.bounds != null) {
                return this.bounds;
            }
            this.bounds = new BoundingBox(this.func_174877_v()).expand((double)this.getRange(), 1.0, (double)this.getRange());
            if (this.capturedMob != null && (ent = this.capturedMob.getEntity(this.field_145850_b, false)) != null) {
                int height = Math.max((int)Math.ceil(ent.field_70131_O) - 1, 0);
                this.bounds = this.bounds.setMaxY(this.bounds.field_72337_e + (double)height);
                return this.bounds;
            }
        }
        return new BoundingBox(this.func_174877_v());
    }

    public int getRange() {
        return SpawnerConfig.poweredSpawnerSpawnRange.get();
    }

    public void setNotification(SpawnerNotification note) {
        if (!this.notification.contains(note)) {
            this.notification.add(note);
            this.sendNotification = true;
        }
    }

    public void removeNotification(SpawnerNotification note) {
        if (this.getNotification().remove(note)) {
            this.sendNotification = true;
        }
    }

    public void clearNotification() {
        if (this.hasNotification()) {
            this.getNotification().clear();
            this.sendNotification = true;
        }
    }

    public void replaceNotification(Set<SpawnerNotification> notes) {
        this.getNotification().clear();
        for (SpawnerNotification note : notes) {
            this.getNotification().add(note);
        }
    }

    public boolean hasNotification() {
        return !this.getNotification().isEmpty();
    }

    public boolean hasNotification(SpawnerNotification note) {
        return this.getNotification().contains(note);
    }

    @Nonnull
    public Set<SpawnerNotification> getNotification() {
        return this.notification;
    }

    private void sendNotification() {
        this.sendNotification = false;
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSpawnerUpdateNotification(this, this.getNotification()));
    }

    @Override
    @Nonnull
    public NNList<CapturedMob> getEntities() {
        if (this.capturedMob != null) {
            return new NNList((Object[])new CapturedMob[]{this.capturedMob});
        }
        return NNList.emptyList();
    }

    @Override
    @Nonnull
    public EntityAction getEntityAction() {
        return EntityAction.SPAWN;
    }
}

