/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.sagmill;

import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskBlock;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.machines.machine.sagmill.ContainerSagMill;
import crazypants.enderio.machines.machine.sagmill.GuiSagMill;
import crazypants.enderio.machines.machine.sagmill.TileSagMill;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSagMill<T extends TileSagMill>
extends AbstractPoweredTaskBlock<T>
implements IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockSagMill<TileSagMill.Normal> create(@Nonnull IModObject modObject) {
        BlockSagMill<TileSagMill.Normal> res = new BlockSagMill<TileSagMill.Normal>(modObject);
        res.init();
        return res;
    }

    public static BlockSagMill<TileSagMill.Simple> create_simple(@Nonnull IModObject modObject) {
        BlockSagMill<TileSagMill.Simple> res = new BlockSagMill<TileSagMill.Simple>(modObject){

            @Override
            @SideOnly(value=Side.CLIENT)
            @Nonnull
            public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
                return RenderMappers.SIMPLE_BODY_MAPPER;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
                return RenderMappers.SIMPLE_BODY_MAPPER;
            }
        };
        res.init();
        return res;
    }

    private BlockSagMill(@Nonnull IModObject modObject) {
        super(modObject);
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileSagMill te) {
        return ContainerSagMill.create(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileSagMill te) {
        return new GuiSagMill(player.field_71071_by, te);
    }

    @Override
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        TileSagMill te = (TileSagMill)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null && te.isActive()) {
            EnumFacing front = te.facing;
            for (int i = 0; i < 3; ++i) {
                double px = (double)pos.func_177958_n() + 0.5 + (double)front.func_82601_c() * 0.51;
                double pz = (double)pos.func_177952_p() + 0.5 + (double)front.func_82599_e() * 0.51;
                double py = (float)pos.func_177956_o() + world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                double v = 0.05;
                double vx = 0.0;
                double vz = 0.0;
                if (front == EnumFacing.NORTH || front == EnumFacing.SOUTH) {
                    px += (double)world.field_73012_v.nextFloat() * 0.8 - 0.4;
                    vz += front == EnumFacing.NORTH ? -v : v;
                } else {
                    pz += (double)world.field_73012_v.nextFloat() * 0.8 - 0.4;
                    vx += front == EnumFacing.WEST ? -v : v;
                }
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px, py, pz, vx, 0.0, vz, new int[0]);
            }
        }
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileSagMill tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }
}

