/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.reservoir;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.NBTAction;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.TileEntityEio;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@Storable
public class TileReservoir
extends TileEntityEio
implements ITankAccess.IExtendedTankAccess {
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE})
    @Nonnull
    final SmartTank tank = new SmartTank(FluidRegistry.WATER, 1000);
    public boolean canRefill = false;
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE})
    boolean autoEject = false;
    private boolean tankDirty = false;
    private static final int IO_MB_TICK = 100;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileReservoir() {
        this.tank.setTileEntity((TileEntity)this);
    }

    private boolean hasEnoughLiquid() {
        HashSet<TileReservoir> seen = new HashSet<TileReservoir>();
        seen.add(this);
        int got = this.tank.getFluidAmount();
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            BlockPos pos1 = this.func_174877_v().func_177972_a((EnumFacing)itr.next());
            TileEntity tileEntity = this.field_145850_b.func_175625_s(pos1);
            if (!(tileEntity instanceof TileReservoir) || seen.contains(tileEntity)) continue;
            seen.add((TileReservoir)tileEntity);
            if ((got += ((TileReservoir)tileEntity).tank.getFluidAmount()) >= 2000) {
                return true;
            }
            NNList.NNIterator itr2 = NNList.FACING.fastIterator();
            while (itr2.hasNext()) {
                BlockPos pos2 = pos1.func_177972_a((EnumFacing)itr2.next());
                TileEntity tileEntity2 = this.field_145850_b.func_175625_s(pos2);
                if (!(tileEntity2 instanceof TileReservoir) || seen.contains(tileEntity2)) continue;
                seen.add((TileReservoir)tileEntity2);
                if ((got += ((TileReservoir)tileEntity2).tank.getFluidAmount()) < 2000) continue;
                return true;
            }
        }
        return false;
    }

    protected void doPush() {
        if (!this.tank.isEmpty()) {
            NNList.NNIterator itr = NNList.FACING.fastIterator();
            while (itr.hasNext() && !this.tank.isEmpty()) {
                EnumFacing dir = (EnumFacing)itr.next();
                BlockPos neighbor = this.func_174877_v().func_177972_a(dir);
                if (this.field_145850_b.func_180495_p(neighbor).func_177230_c() == this.field_145854_h || FluidWrapper.transfer((FluidTank)this.tank, (IBlockAccess)this.field_145850_b, (BlockPos)neighbor, (EnumFacing)dir.func_176734_d(), (int)100) <= 0) continue;
                this.setTanksDirty();
            }
        }
    }

    protected void doLeak() {
        BlockPos down = this.func_174877_v().func_177977_b();
        if (this.doLeak(down)) {
            NNList.NNIterator itr = NNList.FACING_HORIZONTAL.fastIterator();
            while (itr.hasNext() && !this.tank.isEmpty()) {
                this.doLeak(down.func_177972_a((EnumFacing)itr.next()));
            }
        }
    }

    protected boolean doLeak(@Nonnull BlockPos otherPos) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(otherPos);
        if (tileEntity instanceof TileReservoir) {
            FluidStack canDrain;
            TileReservoir otherTe = (TileReservoir)tileEntity;
            if (!otherTe.tank.isFull() && (canDrain = this.tank.drainInternal(otherTe.tank.getAvailableSpace(), false)) != null && canDrain.amount > 0) {
                int fill = otherTe.tank.fill(canDrain, true);
                this.tank.drainInternal(fill, true);
                otherTe.setTanksDirty();
                this.setTanksDirty();
            }
            return true;
        }
        return false;
    }

    protected void doEqualize() {
        NNList.NNIterator itr = NNList.FACING_HORIZONTAL.fastIterator();
        while (itr.hasNext() && !this.tank.isEmpty()) {
            FluidStack canDrain;
            BlockPos pos1 = this.func_174877_v().func_177972_a((EnumFacing)itr.next());
            TileEntity tileEntity = this.field_145850_b.func_175625_s(pos1);
            if (!(tileEntity instanceof TileReservoir)) continue;
            TileReservoir other = (TileReservoir)tileEntity;
            int toMove = (this.tank.getFluidAmount() - other.tank.getFluidAmount()) / 2;
            if (toMove <= 0 || (canDrain = this.tank.drainInternal(Math.min(toMove, 25), false)) == null || canDrain.amount <= 0) continue;
            int fill = ((TileReservoir)tileEntity).tank.fill(canDrain, true);
            this.tank.drainInternal(fill, true);
            ((TileReservoir)tileEntity).setTanksDirty();
            this.setTanksDirty();
        }
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            super.doUpdate();
            return;
        }
        if (this.shouldDoWorkThisTick(10)) {
            if (this.tankDirty || !this.tank.isFull() || !this.canRefill) {
                this.canRefill = this.hasEnoughLiquid();
            }
        } else if (this.canRefill && !this.tank.isFull() && this.shouldDoWorkThisTick(10, -1)) {
            this.tank.addFluidAmount(500);
            this.setTanksDirty();
        }
        if (this.shouldDoWorkThisTick(15, 1) && !this.tank.isEmpty()) {
            this.doLeak();
            if (!this.tank.isEmpty()) {
                this.doEqualize();
            }
        }
        if (this.autoEject && this.canRefill) {
            this.doPush();
        }
        if (this.tankDirty && this.shouldDoWorkThisTick(5)) {
            this.forceUpdatePlayers();
            this.tankDirty = false;
        }
    }

    public void setAutoEject(boolean autoEject) {
        this.autoEject = autoEject;
        this.setTanksDirty();
    }

    public boolean isAutoEject() {
        return this.autoEject;
    }

    float getFilledRatio() {
        return this.tank.getFilledRatio();
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == FluidRegistry.WATER) {
            return this.tank;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        if (!this.tankDirty) {
            this.tankDirty = true;
            this.func_70296_d();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && !this.tank.isEmpty();
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.OUTPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileReservoir.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileReservoir.this.tank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidHandler(new IFluidHandler[]{this.tank}){

                protected boolean canFill(@Nonnull EnumFacing from) {
                    return true;
                }

                protected boolean canDrain(@Nonnull EnumFacing from) {
                    return TileReservoir.this.canRefill;
                }

                protected boolean canAccess(@Nonnull EnumFacing from) {
                    return true;
                }
            };
        }
        return this.smartTankFluidHandler;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getSmartTankFluidHandler().has(facingIn);
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }
}

