/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.reservoir;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.util.NNList;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

class ReservoirTankWrapper
implements ITankAccess {
    @Nonnull
    private final NNList<ITankAccess> parents = new NNList();
    private SmartTank tank;
    @Nonnull
    private final World world;
    @Nonnull
    private final BlockPos pos;

    ReservoirTankWrapper(@Nonnull ITankAccess parent, @Nonnull World world, @Nonnull BlockPos pos) {
        this.parents.add((Object)parent);
        this.world = world;
        this.pos = pos;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        FluidTank parentTank = ((ITankAccess)this.parents.get(0)).getInputTank(forFluidType);
        if (parentTank == null) {
            return null;
        }
        int free = parentTank.getCapacity() - parentTank.getFluidAmount();
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            FluidTank tank2;
            TileEntity neighbor = this.world.func_175625_s(this.pos.func_177972_a((EnumFacing)itr.next()));
            if (!(neighbor instanceof ITankAccess) || (tank2 = ((ITankAccess)neighbor).getInputTank(forFluidType)) == null) continue;
            free += tank2.getCapacity() - tank2.getFluidAmount();
            this.parents.add((Object)((ITankAccess)neighbor));
        }
        if (free < 1000) {
            free = 1000;
        }
        this.tank = new SmartTank(parentTank.getFluid(), free);
        return this.tank;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return ((ITankAccess)this.parents.get(0)).getOutputTanks();
    }

    public void setTanksDirty() {
        if (this.tank != null) {
            FluidStack stack = this.tank.getFluid();
            if (stack != null && stack.amount > 0) {
                for (ITankAccess parent : this.parents) {
                    FluidTank ptank = parent.getInputTank(stack);
                    if (ptank == null) continue;
                    stack.amount -= ptank.fill(stack, true);
                    parent.setTanksDirty();
                    if (stack.amount > 0) continue;
                    return;
                }
            }
            this.tank.setCapacity(0);
        }
    }
}

