/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.base;

import crazypants.enderio.machines.config.config.InhibitorConfig;
import crazypants.enderio.machines.machine.obelisk.base.ISpawnCallback;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SpawningObeliskController {
    public static SpawningObeliskController instance = new SpawningObeliskController();
    @Nonnull
    private final Map<Integer, Map<BlockPos, ISpawnCallback>> perWorldGuards = new HashMap<Integer, Map<BlockPos, ISpawnCallback>>();

    private SpawningObeliskController() {
    }

    public <T extends TileEntity> void registerGuard(T guard) {
        if (guard == null) {
            return;
        }
        Map<BlockPos, ISpawnCallback> chargers = this.getGuardsForWorld(guard.func_145831_w());
        chargers.put(guard.func_174877_v(), (ISpawnCallback)guard);
    }

    public <T extends TileEntity> void deregisterGuard(T guard) {
        if (guard == null) {
            return;
        }
        Map<BlockPos, ISpawnCallback> chargers = this.getGuardsForWorld(guard.func_145831_w());
        chargers.remove(guard.func_174877_v());
    }

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.getResult() == Event.Result.DENY) {
            return;
        }
        if (InhibitorConfig.stopAllSlimes.get().booleanValue() && evt.getEntity() instanceof EntitySlime) {
            evt.setResult(Event.Result.DENY);
            return;
        }
        if (InhibitorConfig.stopAllSquid.get().booleanValue() && evt.getEntity().getClass() == EntitySquid.class) {
            evt.setResult(Event.Result.DENY);
            return;
        }
        Map<BlockPos, ISpawnCallback> guards = this.getGuardsForWorld(evt.getWorld());
        for (ISpawnCallback guard : guards.values()) {
            ISpawnCallback.Result result = guard.isSpawnPrevented(evt.getEntityLiving());
            if (result == ISpawnCallback.Result.DENY) {
                evt.setResult(Event.Result.DENY);
                return;
            }
            if (result != ISpawnCallback.Result.DONE) continue;
            return;
        }
    }

    @Nonnull
    private Map<BlockPos, ISpawnCallback> getGuardsForWorld(World world) {
        Map<BlockPos, ISpawnCallback> res = this.perWorldGuards.get(world.field_73011_w.getDimension());
        if (res == null) {
            res = new HashMap<BlockPos, ISpawnCallback>();
            this.perWorldGuards.put(world.field_73011_w.getDimension(), res);
        }
        return res;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

