/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.killera;

import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineBlock;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.machines.config.Config;
import crazypants.enderio.machines.machine.killera.ContainerKillerJoe;
import crazypants.enderio.machines.machine.killera.GuiKillerJoe;
import crazypants.enderio.machines.machine.killera.KillerJoeRenderMapper;
import crazypants.enderio.machines.machine.killera.KillerJoeRenderer;
import crazypants.enderio.machines.machine.killera.TileKillerJoe;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class BlockKillerJoe
extends AbstractInventoryMachineBlock<TileKillerJoe>
implements IHaveTESR {
    static final String USERNAME = "KillerJoe";
    public static final TextureRegistry.TextureSupplier textureHead1 = TextureRegistry.registerTexture("blocks/killer_joe_head");
    public static final TextureRegistry.TextureSupplier textureHead2 = TextureRegistry.registerTexture("blocks/killer_joe_head2");
    private static final Double px = 0.0625;
    @Nonnull
    public static final AxisAlignedBB AABB = new AxisAlignedBB(2.0 * px, 0.0 * px, 2.0 * px, 14.0 * px, 16.0 * px, 14.0 * px);
    @Nonnull
    protected static String permissionAttacking = "(unititialized)";

    public static BlockKillerJoe create(@Nonnull IModObject modObject) {
        BlockKillerJoe res = new BlockKillerJoe(modObject);
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected BlockKillerJoe(@Nonnull IModObject modObject) {
        super(modObject, new Material(MapColor.field_151668_h){

            public boolean func_76218_k() {
                return false;
            }
        });
        this.func_149713_g(5);
        this.func_149672_a(SoundType.field_185853_f);
        this.setShape(this.mkShape(BlockFaceShape.MIDDLE_POLE_THICK, BlockFaceShape.MIDDLE_POLE_THICK, BlockFaceShape.UNDEFINED));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return AABB;
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity exploder, @Nonnull Explosion explosion) {
        return Config.explosionResistantBlockHardness.get().floatValue();
    }

    @SubscribeEvent
    public void getKillDisplayName(PlayerEvent.NameFormat nameEvt) {
        if (nameEvt.getUsername() != null && nameEvt.getUsername().startsWith(USERNAME)) {
            nameEvt.setDisplayname(this.func_149732_F());
        }
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileKillerJoe te) {
        return new ContainerKillerJoe(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileKillerJoe te) {
        return new GuiKillerJoe(player.field_71071_by, te);
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState bs) {
        return false;
    }

    @Override
    @Nonnull
    protected EnumFacing getFacingForHeading(@Nonnull EntityLivingBase player) {
        return super.getFacingForHeading(player).func_176734_d();
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileKillerJoe tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return KillerJoeRenderMapper.killerJoe;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return KillerJoeRenderMapper.killerJoe;
    }

    @Override
    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileKillerJoe.class, (TileEntitySpecialRenderer)new KillerJoeRenderer());
    }

    @Override
    public void init(@Nonnull IModObject mo, @Nonnull FMLInitializationEvent event) {
        super.init(mo, event);
        permissionAttacking = PermissionAPI.registerNode((String)("enderio.attack." + mo.getRegistryName().func_110623_a().toLowerCase(Locale.ENGLISH)), (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Permission for the block " + mo.getUnlocalisedName() + " of Ender IO to attack entities. Note: The GameProfile will be for the block owner, the EntityPlayer in the context will be the fake player."));
    }
}

