/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.zombie;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.machines.config.config.ZombieGenConfig;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machines.machine.generator.zombie.TileZombieGenerator;
import java.awt.Color;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class GuiZombieGenerator
extends GuiInventoryMachineBase<TileZombieGenerator> {
    @Nonnull
    private static final Rectangle RECTANGLE_FUEL_TANK = new Rectangle(80, 21, 15, 47);

    public GuiZombieGenerator(@Nonnull InventoryPlayer inventory, final @Nonnull TileZombieGenerator tileEntity) {
        super(tileEntity, (Container)new ContainerZombieGenerator(inventory, tileEntity), "zombie_generator");
        this.addToolTip(new GuiToolTip(RECTANGLE_FUEL_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Lang.GUI_ZOMBGEN_FTANK.get());
                this.text.add(LangFluid.MB((IFluidTank)((TileZombieGenerator)((GuiZombieGenerator)GuiZombieGenerator.this).getTileEntity()).tank));
                if (tileEntity.tank.getFluidAmount() < tileEntity.getActivationAmount()) {
                    this.text.add(Lang.GUI_ZOMBGEN_MINREQ.get(LangFluid.MB(tileEntity.getActivationAmount())));
                }
            }
        });
        this.addDrawingElement(new PowerBar(tileEntity, this));
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_FUEL_TANK.contains(mouseX, mouseY)) {
            return ((TileZombieGenerator)this.getTileEntity()).tank.getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    public void renderSlotHighlights(@Nonnull IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 78;
            int y = 19;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        TileZombieGenerator gen = (TileZombieGenerator)this.getTileEntity();
        FontRenderer fr = this.getFontRenderer();
        int output = 0;
        if (gen.isActive()) {
            output = gen.getPowerUsePerTick();
        }
        String txt = Lang.GUI_ZOMBGEN_OUTPUT.get(LangPower.RFt(output));
        int sw = fr.func_78256_a(txt);
        fr.func_175063_a(txt, (float)(this.field_147003_i + this.field_146999_f / 2 - sw / 2), (float)(this.field_147009_r + fr.field_78288_b / 2 + 3), ColorUtil.getRGB((Color)Color.WHITE));
        int x = this.field_147003_i + 80;
        int y = this.field_147009_r + 21;
        if (!gen.tank.isEmpty()) {
            RenderUtil.renderGuiTank((FluidStack)gen.tank.getFluid(), (int)gen.tank.getCapacity(), (int)gen.tank.getFluidAmount(), (double)x, (double)y, (double)this.field_73735_i, (double)16.0, (double)47.0);
            if (gen.isActive()) {
                txt = LangFluid.tMB(ZombieGenConfig.ticksPerBucketOfFuel.get() / 1000);
                sw = fr.func_78256_a(txt);
                fr.func_175063_a(txt, (float)(x - sw / 2 + 7), (float)(y + fr.field_78288_b / 2 + 46), ColorUtil.getRGB((Color)Color.WHITE));
            }
        }
        this.bindGuiTexture();
        super.func_146976_a(par1, par2, par3);
    }
}

