/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.stirling;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorData;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.generator.stirling.ContainerStirlingGenerator;
import crazypants.enderio.machines.machine.generator.stirling.TileStirlingGenerator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.FieldPosition;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiStirlingGenerator<T extends TileStirlingGenerator>
extends GuiInventoryMachineBase<T> {
    private final boolean isSimple;

    public GuiStirlingGenerator(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull T te) {
        super(te, (Container)new ContainerStirlingGenerator<T>(par1InventoryPlayer, te), "stirling_generator", "simple_stirling_generator");
        this.isSimple = te instanceof TileStirlingGenerator.Simple;
        if (!this.isSimple) {
            final ContainerStirlingGenerator c = (ContainerStirlingGenerator)this.field_147002_h;
            Rectangle r = new Rectangle(c.getUpgradeOffset(), new Dimension(16, 16));
            MessageFormat fmt = new MessageFormat(Lang.GUI_STIRGEN_UPGRADES.get());
            this.ttMan.addToolTip(new GuiToolTip(r, new String[]{Lang.GUI_STIRGEN_SLOT.get(), GuiStirlingGenerator.formatUpgrade(fmt, DefaultCapacitorData.ACTIVATED_CAPACITOR), GuiStirlingGenerator.formatUpgrade(fmt, DefaultCapacitorData.ENDER_CAPACITOR)}){

                public boolean shouldDraw() {
                    return !c.getUpgradeSlot().func_75216_d() && super.shouldDraw();
                }
            });
        } else {
            this.redstoneButton.setIsVisible(false);
        }
        this.addProgressTooltip(80, 52, 14, 14);
        this.addDrawingElement(new PowerBar((IPowerBarData)te, this));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ((ContainerStirlingGenerator)this.field_147002_h).addGhostslots((NNList<GhostSlot>)this.getGhostSlotHandler().getGhostSlots());
    }

    private static float getFactor(@Nonnull ICapacitorData upgrade) {
        return TileStirlingGenerator.getEnergyMultiplier(upgrade) * TileStirlingGenerator.getBurnTimeMultiplier(upgrade);
    }

    private static String formatUpgrade(@Nonnull MessageFormat fmt, @Nonnull ICapacitorData upgrade) {
        float efficiency = GuiStirlingGenerator.getFactor(upgrade) / GuiStirlingGenerator.getFactor(DefaultCapacitorData.BASIC_CAPACITOR);
        Object[] args = new Object[]{upgrade.getLocalizedName(), Float.valueOf(efficiency), TextFormatting.WHITE, TextFormatting.GRAY};
        return fmt.format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    @Override
    protected String formatProgressTooltip(int scaledProgress, float remaining) {
        int totalBurnTime = ((TileStirlingGenerator)this.getTileEntity()).totalBurnTime;
        int remainingTicks = (int)(remaining * (float)totalBurnTime);
        int remainingSecs = remainingTicks / 20;
        int remainingPower = ((TileStirlingGenerator)this.getTileEntity()).getPowerUsePerTick() * remainingTicks;
        Object[] objects = new Object[]{Float.valueOf(remaining), remainingSecs / 60, remainingSecs % 60, remainingPower};
        return MessageFormat.format(Lang.GUI_STIRGEN_REMAINING.get(), objects);
    }

    @Override
    protected int scaleProgressForTooltip(float progress) {
        int totalBurnTime = ((TileStirlingGenerator)this.getTileEntity()).totalBurnTime;
        int scale = Math.max(100, (totalBurnTime + 19) / 20);
        return (int)(progress * (float)scale);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture(this.isSimple ? 1 : 0);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.shouldRenderProgress()) {
            int scaled = this.getProgressScaled(12);
            this.func_73729_b(sx + 80, sy + 64 - scaled, 176, 12 - scaled, 14, scaled + 2);
        }
        FontRenderer fr = this.getFontRenderer();
        int y = this.field_147009_r + fr.field_78288_b / 2 + 3;
        int output = 0;
        if (((TileStirlingGenerator)this.getTileEntity()).isActive()) {
            output = ((TileStirlingGenerator)this.getTileEntity()).getPowerUsePerTick();
        }
        String txt = Lang.GUI_STIRGEN_OUTPUT.get(LangPower.RFt(output));
        int sw = fr.func_78256_a(txt);
        fr.func_175063_a(txt, (float)(this.field_147003_i + this.field_146999_f / 2 - sw / 2), (float)y, ColorUtil.getRGB((Color)Color.WHITE));
        txt = Lang.GUI_STIRGEN_RATE.get(Math.round(((TileStirlingGenerator)this.getTileEntity()).getBurnTimeMultiplier() / TileStirlingGenerator.getBurnTimeMultiplier(DefaultCapacitorData.BASIC_CAPACITOR) * 100.0f));
        sw = fr.func_78256_a(txt);
        fr.func_175063_a(txt, (float)(this.field_147003_i + this.field_146999_f / 2 - sw / 2), (float)(y += fr.field_78288_b + 3), ColorUtil.getRGB((Color)Color.WHITE));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(par1, par2, par3);
    }
}

