/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.combustion;

import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.machine.base.block.BlockMachineExtension;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.baselegacy.AbstractGeneratorBlock;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.generator.combustion.ContainerCombustionGenerator;
import crazypants.enderio.machines.machine.generator.combustion.GuiCombustionGenerator;
import crazypants.enderio.machines.machine.generator.combustion.TileCombustionGenerator;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCombustionGenerator<T extends TileCombustionGenerator>
extends AbstractGeneratorBlock<T>
implements IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    protected boolean isEnhanced = false;

    public static BlockCombustionGenerator<TileCombustionGenerator> create(@Nonnull IModObject modObject) {
        BlockCombustionGenerator<TileCombustionGenerator> gen = new BlockCombustionGenerator<TileCombustionGenerator>(modObject);
        gen.init();
        return gen;
    }

    public static BlockCombustionGenerator<TileCombustionGenerator.Enhanced> create_enhanced(@Nonnull IModObject modObject) {
        BlockCombustionGenerator<TileCombustionGenerator.Enhanced> gen = new BlockCombustionGenerator<TileCombustionGenerator.Enhanced>(modObject);
        gen.init();
        gen.isEnhanced = true;
        return gen;
    }

    public static BlockMachineExtension create_extension(@Nonnull IModObject modObject) {
        return new BlockMachineExtension(modObject, MachineObject.block_enhanced_combustion_generator, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0));
    }

    protected BlockCombustionGenerator(@Nonnull IModObject modObject) {
        super(modObject);
        this.setShape(this.mkShape(BlockFaceShape.UNDEFINED, BlockFaceShape.SOLID));
    }

    public int func_149717_k(@Nonnull IBlockState bs) {
        return 0;
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull T te) {
        return new ContainerCombustionGenerator<T>(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull T te) {
        return new GuiCombustionGenerator<T>(player.field_71071_by, te);
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    @Override
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (this.isActive((IBlockAccess)world, pos)) {
            TileEntity te = world.func_175625_s(pos);
            EnumFacing facing = EnumFacing.SOUTH;
            if (te instanceof AbstractMachineEntity) {
                AbstractMachineEntity me = (AbstractMachineEntity)te;
                facing = me.facing;
            }
            for (int j = 0; j < (this.isEnhanced ? 3 : 1); ++j) {
                boolean toTop = rand.nextBoolean();
                float offsetA = rand.nextFloat();
                float offsetB = 0.5f + rand.nextFloat() * 0.2f - rand.nextFloat() * 0.2f;
                float startX = pos.func_177958_n();
                float startY = pos.func_177956_o();
                float startZ = pos.func_177952_p();
                if (toTop) {
                    startY += 0.95f;
                    switch (facing) {
                        case NORTH: 
                        case SOUTH: {
                            startX += offsetB;
                            startZ += offsetA;
                            break;
                        }
                        default: {
                            startX += offsetA;
                            startZ += offsetB;
                            break;
                        }
                    }
                } else {
                    boolean swap = rand.nextBoolean();
                    startY += offsetA;
                    switch (facing) {
                        case NORTH: 
                        case SOUTH: {
                            startX += offsetB;
                            startZ += swap ? 0.05f : 0.95f;
                            break;
                        }
                        default: {
                            startX += swap ? 0.05f : 0.95f;
                            startZ += offsetB;
                        }
                    }
                }
                for (int i = 0; i < (this.isEnhanced ? 5 : 2); ++i) {
                    ParticleManager er = Minecraft.func_71410_x().field_71452_i;
                    Particle fx = er.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), (double)startX, (double)startY, (double)startZ, 0.0, 0.0, 0.0, new int[0]);
                    if (fx != null && rand.nextFloat() > 0.75f) {
                        fx.func_70538_b(1.0f - rand.nextFloat() * 0.2f, 1.0f - rand.nextFloat() * 0.1f, 1.0f - rand.nextFloat() * 0.2f);
                    }
                    startX += rand.nextFloat() * 0.1f - rand.nextFloat() * 0.1f;
                    startY += rand.nextFloat() * 0.1f - rand.nextFloat() * 0.1f;
                    startZ += rand.nextFloat() * 0.1f - rand.nextFloat() * 0.1f;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileCombustionGenerator tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }

    public boolean func_176196_c(@Nonnull World world, @Nonnull BlockPos pos) {
        return super.func_176196_c(world, pos) && (!this.isEnhanced || pos.func_177956_o() < 255 && super.func_176196_c(world, pos.func_177984_a()));
    }

    @Override
    public void onBlockPlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull T te) {
        super.onBlockPlaced(world, pos, state, player, te);
        if (this.isEnhanced) {
            world.func_175656_a(pos.func_177984_a(), MachineObject.block_enhanced_combustion_generator_top.getBlockNN().func_176223_P());
        }
    }

    @Override
    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (this.isEnhanced && world.func_180495_p(pos.func_177984_a()).func_177230_c() != MachineObject.block_enhanced_combustion_generator_top.getBlockNN()) {
            if (super.func_176196_c(world, pos.func_177984_a())) {
                world.func_175656_a(pos.func_177984_a(), MachineObject.block_enhanced_combustion_generator_top.getBlockNN().func_176223_P());
            } else {
                world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 3.0f, true);
            }
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }
}

