/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.farm;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.NBTAction;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.blockiterators.PlanarBlockIterator;
import com.enderio.core.common.vecmath.Vector4f;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmingTool;
import crazypants.enderio.api.farm.IFertilizer;
import crazypants.enderio.api.farm.IFertilizerResult;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.fertilizer.Fertilizer;
import crazypants.enderio.base.farming.registry.Commune;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.task.ContinuousTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.FarmConfig;
import crazypants.enderio.machines.machine.farm.BlockFarmStation;
import crazypants.enderio.machines.machine.farm.FarmLogic;
import crazypants.enderio.machines.machine.farm.FarmSlots;
import crazypants.enderio.machines.machine.farm.PacketFarmAction;
import crazypants.enderio.machines.machine.farm.PacketFarmLockedSlot;
import crazypants.enderio.machines.machine.farm.PacketUpdateNotification;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.minecraft.HandleItemStack;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;

@Storable
public class TileFarmStation
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity,
IRanged,
INotifier {
    public static final int NUM_TOOL_SLOTS = 3;
    public static final int minToolSlot = 0;
    public static final int maxToolSlot = 2;
    public static final int NUM_FERTILIZER_SLOTS = 2;
    public static final int minFirtSlot = 3;
    public static final int maxFirtSlot = 4;
    public static final int NUM_SUPPLY_SLOTS = 4;
    public static final int minSupSlot = 5;
    public static final int maxSupSlot = 8;
    @Store
    private int lockedSlots = 0;
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleItemStack.HandleItemStackNNList.class)
    @Nonnull
    private NNList<ItemStack> overflowQueue = new NNList();
    @Nonnull
    private final Set<FarmNotification> notification = EnumSet.noneOf(FarmNotification.class);
    private boolean sendNotification = false;
    private boolean wasActive;
    private EnumMap<FarmingTool, FarmSlots> toolmapping = new EnumMap(FarmingTool.class);
    private boolean toolmappingInitialized = false;
    private IFarmer farmerCache;
    private int bonemealCooldown = 4;
    private PlanarBlockIterator blockIterator;
    private boolean showingRange;
    private static final Vector4f color = new Vector4f(0.5686275f, 0.32156864f, 0.08235294f, 0.4f);

    public TileFarmStation() {
        super(new SlotDefinition(9, 6, 1), CapacitorKey.FARM_POWER_INTAKE, CapacitorKey.FARM_POWER_BUFFER, CapacitorKey.FARM_POWER_USE);
    }

    public int getFarmSize() {
        return (int)(CapacitorKey.FARM_BASE_SIZE.getFloat(this.getCapacitorData()) + CapacitorKey.FARM_BONUS_SIZE.getFloat(this.getCapacitorData()));
    }

    public void setNotification(@Nonnull FarmNotification note) {
        if (!this.notification.contains(note)) {
            this.notification.add(note);
            this.sendNotification = true;
        }
    }

    public void removeNotification(FarmNotification note) {
        if (this.getNotification().remove(note)) {
            this.sendNotification = true;
        }
    }

    public void clearNotification() {
        if (this.hasNotification()) {
            this.getNotification().clear();
            this.sendNotification = true;
        }
    }

    public boolean hasNotification() {
        return !this.getNotification().isEmpty();
    }

    private void sendNotification() {
        PacketHandler.sendToAllAround((IMessage)new PacketUpdateNotification(this, this.notification), (TileEntity)this);
        this.sendNotification = false;
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        if (i <= 2) {
            FarmingTool toolType = FarmingTool.getToolType(stack);
            if (toolType != FarmingTool.NONE && !FarmingTool.isBrokenTinkerTool(stack) && !FarmingTool.isDryRfTool(stack)) {
                return this.getSlotForTool(toolType) == null;
            }
            return false;
        }
        if (i <= 4) {
            return Fertilizer.isFertilizer(stack);
        }
        if (i <= 8) {
            return this.isSlotLocked(i) ? ItemUtil.areStacksEqual((ItemStack)stack, (ItemStack)this.getStackInSlot(i)) : Commune.instance.canPlant(stack);
        }
        return false;
    }

    private void buildToolmapping() {
        if (!this.toolmappingInitialized || this.field_145850_b.field_72995_K) {
            this.toolmapping.clear();
            this.toolmapping.put(FarmingTool.getToolType(this.getStackInSlot(0)), FarmSlots.TOOL1);
            this.toolmapping.put(FarmingTool.getToolType(this.getStackInSlot(1)), FarmSlots.TOOL2);
            this.toolmapping.put(FarmingTool.getToolType(this.getStackInSlot(2)), FarmSlots.TOOL3);
            this.toolmappingInitialized = true;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.toolmappingInitialized = false;
    }

    protected FarmSlots getSlotForTool(@Nonnull IFarmingTool tool) {
        this.buildToolmapping();
        return this.toolmapping.get(tool);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.isActive() != this.wasActive) {
            this.wasActive = this.isActive();
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    @Override
    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.shouldDoWorkThisTick(1200)) {
            this.clearNotification();
        }
        if (redstoneChecksPassed) {
            if (this.tryToUsePower()) {
                this.removeNotification(FarmNotification.NO_POWER);
                if (this.shouldDoWorkThisTick(2)) {
                    if (this.isOutputFull()) {
                        this.setNotification(FarmNotification.OUTPUT_FULL);
                    } else {
                        this.removeNotification(FarmNotification.OUTPUT_FULL);
                        this.doTick();
                    }
                }
            } else {
                this.setNotification(FarmNotification.NO_POWER);
            }
        }
        if (this.sendNotification) {
            this.sendNotification();
        }
        return false;
    }

    @Nonnull
    private IFarmer getFarmer() {
        return this.farmerCache != null ? this.farmerCache : (this.farmerCache = new FarmLogic(this));
    }

    protected void doTick() {
        IFarmer farmer = this.getFarmer();
        BlockPos farmingPos = null;
        IBlockState bs = null;
        int infiniteLoop = 20;
        while (farmingPos == null || bs == null || farmingPos.equals((Object)this.func_174877_v()) || !this.field_145850_b.func_175667_e(farmingPos) || !PermissionAPI.hasPermission((GameProfile)this.getOwner().getAsGameProfile(), (String)BlockFarmStation.permissionFarming, (IContext)new BlockPosContext((EntityPlayer)farmer.getFakePlayer(), farmingPos, bs, null))) {
            if (infiniteLoop-- <= 0) {
                return;
            }
            farmingPos = this.getNextCoord();
            bs = this.field_145850_b.func_180495_p(farmingPos);
        }
        Block block = bs.func_177230_c();
        if (this.isOpen(farmingPos, block)) {
            Commune.instance.prepareBlock(farmer, farmingPos, block, bs);
            bs = this.field_145850_b.func_180495_p(farmingPos);
            block = bs.func_177230_c();
        }
        if (!this.isOpen(farmingPos, block) && !this.executeHarvest(farmer, farmingPos, bs, block)) {
            this.executeBonemeal(farmer, farmingPos, block);
        }
    }

    private void executeBonemeal(@Nonnull IFarmer farmer, @Nonnull BlockPos farmingPos, @Nonnull Block block) {
        ItemStack fertStack;
        IFertilizer fertilizer;
        boolean doApply;
        if (this.hasBonemeal() && this.bonemealCooldown-- <= 0 && this.random.nextFloat() <= FarmConfig.farmBonemealChance.get().floatValue() && farmer.checkAction(FarmingAction.FERTILIZE, FarmingTool.HAND) && (doApply = (fertilizer = Fertilizer.getInstance(fertStack = this.getStackInSlot(3))).applyOnPlant() && fertilizer.applyOnAir() ? !this.isOpen(farmingPos, block) || this.field_145850_b.func_175623_d(farmingPos) : (fertilizer.applyOnPlant() ? !this.isOpen(farmingPos, block) : (fertilizer.applyOnAir() ? this.field_145850_b.func_175623_d(farmingPos) : true)))) {
            FakePlayer farmerJoe = farmer.startUsingItem(Prep.getEmpty());
            IFertilizerResult result = fertilizer.apply(fertStack, (EntityPlayer)farmerJoe, this.field_145850_b, farmingPos);
            if (result.wasApplied()) {
                this.setInventorySlotContents(3, result.getStack());
                PacketHandler.sendToAllAround(new PacketFarmAction(farmingPos), (TileEntity)this);
                this.bonemealCooldown = FarmConfig.farmBonemealDelaySuccess.get();
                farmer.registerAction(FarmingAction.FERTILIZE, FarmingTool.HAND);
            } else {
                this.usePower(FarmConfig.farmBonemealEnergyUseFail.get());
                this.bonemealCooldown = FarmConfig.farmBonemealDelayFail.get();
            }
            farmer.handleExtraItems(farmer.endUsingItem(false), farmingPos);
        }
    }

    private boolean isOpen(@Nonnull BlockPos farmingPos, @Nonnull Block block) {
        return this.field_145850_b.func_175623_d(farmingPos) || block.func_176200_f((IBlockAccess)this.field_145850_b, farmingPos);
    }

    private boolean executeHarvest(@Nonnull IFarmer farmer, final @Nonnull BlockPos farmingPos, @Nonnull IBlockState bs, @Nonnull Block block) {
        IHarvestResult harvest = Commune.instance.harvestBlock(farmer, farmingPos, block, bs);
        if (!(harvest == null || harvest.getHarvestedBlocks().isEmpty() && harvest.getDrops().isEmpty())) {
            if (!harvest.getHarvestedBlocks().isEmpty()) {
                PacketFarmAction pkt = new PacketFarmAction((List<BlockPos>)harvest.getHarvestedBlocks());
                PacketHandler.sendToAllAround(pkt, (TileEntity)this);
            }
            NNList.wrap(harvest.getDrops()).apply((NNList.Callback)new NNList.Callback<EntityItem>(){

                public void apply(@Nonnull EntityItem ei) {
                    if (!ei.field_70128_L) {
                        ItemStack stack = ei.func_92059_d();
                        if (Prep.isValid(stack)) {
                            TileFarmStation.this.getFarmer().handleExtraItem(stack, farmingPos);
                        }
                        ei.func_70106_y();
                    }
                }
            });
            return true;
        }
        return false;
    }

    private boolean hasBonemeal() {
        for (FarmSlots slot : FarmSlots.FERTS) {
            if (!Prep.isValid(slot.get(this))) continue;
            if (slot != FarmSlots.FERT1) {
                FarmSlots.FERT1.set(this, slot.get(this));
                slot.set(this, Prep.getEmpty());
            }
            return true;
        }
        return false;
    }

    private boolean isOutputFull() {
        if (!this.overflowQueue.isEmpty()) {
            NNList<ItemStack> old = this.overflowQueue;
            this.overflowQueue = new NNList();
            this.getFarmer().handleExtraItems((NonNullList<ItemStack>)old, this.field_174879_c);
        }
        if (FarmConfig.useOutputQueue.get().booleanValue()) {
            return !this.overflowQueue.isEmpty();
        }
        for (FarmSlots slot : FarmSlots.OUTPUTS) {
            ItemStack curStack = slot.get(this);
            if (!Prep.isInvalid(curStack) && (FarmConfig.farmStopOnNoOutputSlots.get().booleanValue() || curStack.func_190916_E() >= curStack.func_77976_d())) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    private BlockPos getNextCoord() {
        if (this.blockIterator == null || !this.blockIterator.hasNext()) {
            this.blockIterator = new PlanarBlockIterator(this.func_174877_v(), PlanarBlockIterator.Orientation.HORIZONTAL, this.getFarmSize());
        }
        return this.blockIterator.next();
    }

    public void toggleLockedState(int slot) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer((IMessage)new PacketFarmLockedSlot(this, slot));
        }
        this.setSlotLocked(slot, !this.isSlotLocked(slot));
    }

    public boolean isSlotLocked(FarmSlots slot) {
        return (this.lockedSlots & slot.getBitmask()) != 0;
    }

    public boolean isSlotLocked(int slot) {
        return (this.lockedSlots & 1 << slot - 5) != 0;
    }

    private void setSlotLocked(int slot, boolean value) {
        this.lockedSlots = value ? (this.lockedSlots |= 1 << slot - 5) : (this.lockedSlots &= ~(1 << slot - 5));
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "farmingstation";
    }

    @Override
    public float getProgress() {
        return 0.5f;
    }

    @Override
    public void onCapacitorDataChange() {
        super.onCapacitorDataChange();
        this.currentTask = this.createTask(null, 0L);
    }

    @Override
    protected IPoweredTask createTask(@Nullable IMachineRecipe nextRecipe, long nextSeed) {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public int getInventoryStackLimit(int slot) {
        if (slot >= 5 && slot <= 8) {
            return this.getCapacitorData() == DefaultCapacitorData.NONE ? 0 : Math.min(CapacitorKey.FARM_STACK_LIMIT.get(this.getCapacitorData()), 64);
        }
        return 64;
    }

    @Override
    public int getInventoryStackLimit() {
        return this.getInventoryStackLimit(5);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TileFarmStation>(this, color));
        }
    }

    @Override
    @Nonnull
    public BoundingBox getBounds() {
        return new BoundingBox(this.func_174877_v()).expand((double)this.getRange(), 0.0, (double)this.getRange());
    }

    public float getRange() {
        return this.getFarmSize();
    }

    @Override
    protected int usePower(int wantToUse) {
        return super.usePower(wantToUse);
    }

    @Nonnull
    public Set<FarmNotification> getNotification() {
        return this.notification;
    }

    public void enQueueOverflow(@Nonnull ItemStack stack) {
        this.overflowQueue.add((Object)stack);
    }
}

