/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.farm;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.farm.TileFarmStation;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateNotification
extends MessageTileEntity<TileFarmStation> {
    private Set<FarmNotification> notification;

    public PacketUpdateNotification() {
    }

    public PacketUpdateNotification(@Nonnull TileFarmStation tile, @Nonnull Set<FarmNotification> notification) {
        super((TileEntity)tile);
        this.notification = notification;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.notification = EnumSet.noneOf(FarmNotification.class);
        int count = buf.readByte();
        for (int i = 0; i < count; ++i) {
            this.notification.add(FarmNotification.values()[buf.readByte()]);
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.notification.size());
        for (FarmNotification farmNotification : this.notification) {
            buf.writeByte(farmNotification.ordinal());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateNotification, IMessage> {
        public IMessage onMessage(PacketUpdateNotification message, MessageContext ctx) {
            TileFarmStation te = (TileFarmStation)message.getTileEntity(EnderIO.proxy.getClientWorld());
            if (te != null) {
                te.clearNotification();
                te.getNotification().addAll(message.notification);
            }
            return null;
        }
    }
}

