/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.crafter;

import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityPoweredMachineEntity;
import crazypants.enderio.base.machine.fakeplayer.FakePlayerEIO;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.crafter.DummyCraftingGrid;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.minecraft.HandleItemStack;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Storable
public class TileCrafter
extends AbstractCapabilityPoweredMachineEntity
implements IPaintable.IPaintableTileEntity {
    @Nonnull
    public static final String OUTPUT_SLOT = "OUTPUT";
    @Nonnull
    public static final String INPUT_SLOT = "INPUT";
    public static final int BASE_TICK_RATE = 10;
    @Store
    DummyCraftingGrid craftingGrid = new DummyCraftingGrid();
    @Store(handler=HandleItemStack.HandleItemStackNNList.class)
    private final NNList<ItemStack> containerItems = new NNList();
    @Store
    private boolean bufferStacks = true;
    private long ticksSinceLastCraft = 0L;
    private FakePlayerEIO playerInst;
    private static final UUID uuid = UUID.fromString("9b381cae-3c95-4a64-b958-1e25b0a4c790");
    private static final GameProfile DUMMY_PROFILE = new GameProfile(uuid, "[EioCrafter]");

    public TileCrafter() {
        this(CapacitorKey.CRAFTER_POWER_INTAKE, CapacitorKey.CRAFTER_POWER_BUFFER, CapacitorKey.CRAFTER_POWER_USE);
    }

    public TileCrafter(@Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
        for (int i = 0; i < 9; ++i) {
            this.getInventory().add(EnderInventory.Type.INPUT, INPUT_SLOT + i, new InventorySlot(Filters.ALWAYS_TRUE, Filters.ALWAYS_TRUE));
        }
        this.getInventory().add(EnderInventory.Type.OUTPUT, OUTPUT_SLOT, new InventorySlot(Filters.ALWAYS_FALSE, Filters.ALWAYS_TRUE));
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        ++this.ticksSinceLastCraft;
        if (!(redstoneCheck && this.craftingGrid.hasValidRecipe() && this.canMergeOutput() && this.hasRequiredPower())) {
            return false;
        }
        int ticksPerCraft = this.getTicksPerCraft();
        if (this.ticksSinceLastCraft <= (long)ticksPerCraft) {
            return false;
        }
        this.ticksSinceLastCraft = 0L;
        if (!this.containerItems.isEmpty()) {
            NNList.NNIterator iter = this.containerItems.iterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                InventorySlot outSlot = this.getInventory().getSlot(OUTPUT_SLOT);
                if (!outSlot.get().func_190926_b()) continue;
                outSlot.set(stack);
                iter.remove();
            }
            return false;
        }
        if (this.craftRecipe()) {
            this.getEnergy().extractEnergy(this.getPowerUsePerCraft(), false);
        }
        return false;
    }

    private boolean hasRequiredPower() {
        return this.getEnergy().getEnergyStored() >= this.getPowerUsePerCraft();
    }

    protected int getPowerUsePerCraft() {
        return CapacitorKey.CRAFTER_POWER_CRAFT.get(this.getCapacitorData());
    }

    public int getTicksPerCraft() {
        int impulseHopperSpeedScaled = CapacitorKey.CRAFTER_SPEED.get(this.getCapacitorData());
        if (impulseHopperSpeedScaled > 0) {
            return 10 / impulseHopperSpeedScaled;
        }
        return 10;
    }

    static boolean compareDamageable(@Nonnull ItemStack stack, @Nonnull ItemStack req) {
        if (stack.func_77969_a(req)) {
            return true;
        }
        if (stack.func_77984_f() && stack.func_77973_b() == req.func_77973_b()) {
            return stack.func_77952_i() < stack.func_77958_k();
        }
        return false;
    }

    private boolean craftRecipe() {
        ItemStack stack;
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        int[] usedItems = new int[9];
        for (int j = 0; j < 9; ++j) {
            ItemStack req = this.craftingGrid.func_70301_a(j);
            if (req.func_190926_b()) continue;
            for (int i = 0; i < 9; ++i) {
                stack = this.getInventory().getSlot(INPUT_SLOT + i).get();
                if (stack.func_190926_b() || stack.func_190916_E() <= usedItems[i] || !TileCrafter.compareDamageable(stack, req)) continue;
                req = ItemStack.field_190927_a;
                int n = i;
                usedItems[n] = usedItems[n] + 1;
                ItemStack craftingItem = stack.func_77946_l();
                craftingItem.func_190920_e(1);
                inv.func_70299_a(j, craftingItem);
                break;
            }
            if (req.func_190926_b()) continue;
            return false;
        }
        ItemStack output = ItemStack.field_190927_a;
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)this.field_145850_b);
        if (recipe != null) {
            output = recipe.func_77571_b();
        }
        if (!output.func_190926_b()) {
            if (this.playerInst == null) {
                this.playerInst = new FakePlayerEIO(this.field_145850_b, this.getLocation(), DUMMY_PROFILE);
                this.playerInst.setOwner(this.getOwner());
            }
            MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemCraftedEvent((EntityPlayer)this.playerInst, output, (IInventory)inv));
            NonNullList remaining = CraftingManager.func_180303_b((InventoryCrafting)inv, (World)this.field_145850_b);
            for (int i = 0; i < 9; ++i) {
                ItemStack stack2 = this.getInventory().getSlot(INPUT_SLOT + i).get();
                for (int j = 0; j < usedItems[i] && !stack2.func_190926_b(); ++j) {
                    this.getInventory().getSlot(INPUT_SLOT + i).set(this.eatOneItemForCrafting(i, stack2.func_77946_l(), (NonNullList<ItemStack>)remaining, usedItems[i]));
                }
            }
            for (ItemStack stack2 : remaining) {
                if (stack2.func_190926_b()) continue;
                this.containerItems.add((Object)stack2.func_77946_l());
            }
            ItemStack oldOutput = this.getInventory().getSlot(OUTPUT_SLOT).get();
            if (oldOutput.func_190926_b()) {
                this.getInventory().getSlot(OUTPUT_SLOT).set(output);
            } else if (ItemUtil.areStackMergable((ItemStack)oldOutput, (ItemStack)output)) {
                ItemStack cur = oldOutput.func_77946_l();
                cur.func_190917_f(output.func_190916_E());
                if (cur.func_190916_E() > cur.func_77976_d()) {
                    ItemStack overflow = cur.func_77946_l();
                    overflow.func_190920_e(cur.func_190916_E() - cur.func_77976_d());
                    cur.func_190920_e(cur.func_77976_d());
                    this.containerItems.add((Object)overflow);
                }
                this.getInventory().getSlot(OUTPUT_SLOT).set(cur);
            } else {
                this.containerItems.add((Object)output);
            }
        } else {
            for (int j = 0; j < 9; ++j) {
                stack = this.getInventory().getSlot(INPUT_SLOT + j).get();
                if (usedItems[j] <= 0 || stack.func_190926_b()) continue;
                ItemStack rejected = stack.func_77946_l();
                rejected.func_190920_e(Math.min(stack.func_190916_E(), usedItems[j]));
                this.containerItems.add((Object)rejected);
                if (stack.func_190916_E() <= usedItems[j]) {
                    this.getInventory().insertItem(j, ItemStack.field_190927_a, false);
                    continue;
                }
                stack.func_190918_g(usedItems[j]);
            }
        }
        this.getEnergy().useEnergy(CapacitorKey.CRAFTER_POWER_CRAFT);
        return true;
    }

    @Nonnull
    private ItemStack eatOneItemForCrafting(int slot, @Nonnull ItemStack avail, NonNullList<ItemStack> remaining, int usedItems) {
        ItemStack used;
        if (remaining != null && remaining.size() > 0 && avail.func_77973_b().hasContainerItem(avail) && !(used = avail.func_77973_b().getContainerItem(avail)).func_190926_b()) {
            for (int i = 0; i < remaining.size(); ++i) {
                ItemStack s = (ItemStack)remaining.get(i);
                if (s.func_190926_b() || !s.func_185136_b(used)) continue;
                remaining.set(i, (Object)ItemStack.field_190927_a);
                return s;
            }
        }
        avail.func_190918_g(usedItems);
        if (avail.func_190916_E() == 0) {
            avail = ItemStack.field_190927_a;
        }
        return avail;
    }

    private boolean canMergeOutput() {
        ItemStack oldOutput = this.getInventory().getStackInSlot(9);
        if (oldOutput.func_190926_b()) {
            return true;
        }
        ItemStack output = this.craftingGrid.getOutput();
        if (!ItemUtil.areStackMergable((ItemStack)oldOutput, (ItemStack)output)) {
            return false;
        }
        return output.func_77976_d() >= oldOutput.func_190916_E() + output.func_190916_E();
    }

    public boolean isBufferStacks() {
        return this.bufferStacks;
    }

    public void setBufferStacks(boolean bufferStacks) {
        this.bufferStacks = bufferStacks;
    }

    public void updateCraftingOutput() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.craftingGrid.func_70301_a(i));
        }
        ItemStack matches = ItemStack.field_190927_a;
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)this.field_145850_b);
        if (recipe != null) {
            matches = recipe.func_77571_b();
        }
        this.craftingGrid.func_70299_a(9, matches);
        this.func_70296_d();
    }

    public static class Simple
    extends TileCrafter {
        public Simple() {
            super(CapacitorKey.SIMPLE_CRAFTER_POWER_INTAKE, CapacitorKey.SIMPLE_CRAFTER_POWER_BUFFER, CapacitorKey.SIMPLE_CRAFTER_POWER_USE);
            this.getInventory().getSlot("cap").set(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, DefaultCapacitorData.ENDER_CAPACITOR.ordinal()));
        }

        @Override
        public int getTicksPerCraft() {
            return 20;
        }
    }
}

