/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.buffer;

import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.baselegacy.AbstractPowerConsumerEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.power.ILegacyPowerReceiver;
import crazypants.enderio.base.power.PowerDistributor;
import crazypants.enderio.base.power.forge.InternalRecieverTileWrapper;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.buffer.BufferType;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

@Storable
public abstract class TileBuffer
extends AbstractPowerConsumerEntity
implements ILegacyPowerReceiver,
IPaintable.IPaintableTileEntity {
    @Nonnull
    private final BufferType type;
    private transient PowerDistributor dist;
    @Store
    private int maxOut;
    @Store
    private int maxIn;
    private int maxOutIsMax = 0;
    private int maxInIsMax = 0;

    public TileBuffer(@Nonnull SlotDefinition slotDefinition, @Nonnull BufferType type, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
        this.type = type;
    }

    protected void initMaxIO() {
        if (this.type.isCreative) {
            this.setEnergyStored(this.getMaxEnergyStored() / 2);
            this.func_70296_d();
        }
        if (this.getCapacitorData() != DefaultCapacitorData.NONE || this.maxOut < 0 || this.maxIn < 0) {
            int max = this.getMaxIO();
            if (this.maxOutIsMax == this.maxOut && this.maxOutIsMax != max) {
                this.maxOut = max;
            }
            if (this.maxInIsMax == this.maxIn && this.maxInIsMax != max) {
                this.maxIn = max;
            }
            this.maxIn = MathHelper.func_76125_a((int)this.maxIn, (int)0, (int)max);
            this.maxOut = MathHelper.func_76125_a((int)this.maxOut, (int)0, (int)max);
            this.maxOutIsMax = this.maxOut == max ? max : -9999;
            this.maxInIsMax = this.maxIn == max ? max : -9999;
            this.func_70296_d();
        }
    }

    public int getMaxIO() {
        return this.maxEnergyRecieved.get(this.getCapacitorData());
    }

    @Override
    public void onCapacitorDataChange() {
        this.initMaxIO();
        super.onCapacitorDataChange();
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return this.getType().getUnlocalizedName();
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (!redstoneCheck || this.getEnergyStored() <= 0 || !this.tryToUsePower()) {
            return false;
        }
        if (this.dist == null) {
            this.dist = new PowerDistributor(this.func_174877_v());
        }
        int transmitted = this.dist.transmitEnergy(this.field_145850_b, Math.min(this.getMaxOutput(), this.getEnergyStored()));
        if (!this.isCreative()) {
            this.setEnergyStored(this.getEnergyStored() - transmitted);
        }
        return false;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        super.setIoMode(faceHit, mode);
        if (this.dist != null) {
            this.dist.neighboursChanged();
        }
    }

    @Override
    public void clearAllIoModes() {
        super.clearAllIoModes();
        if (this.dist != null) {
            this.dist.neighboursChanged();
        }
    }

    @Override
    public void onNeighborBlockChange(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        super.onNeighborBlockChange(state, worldIn, posIn, blockIn, fromPos);
        if (this.dist != null) {
            this.dist.neighboursChanged();
        }
    }

    @Override
    public void writeCustomNBT(@Nonnull ItemStack stack) {
        super.writeCustomNBT(stack);
        stack.func_77964_b(this.getType().ordinal());
    }

    @Override
    public void readCustomNBT(@Nonnull ItemStack stack) {
        super.readCustomNBT(stack);
        if (this.type.isCreative) {
            this.setEnergyStored(this.getMaxEnergyStored() / 2);
        }
        this.initMaxIO();
    }

    @Override
    public boolean canConnectEnergy(@Nonnull EnumFacing from) {
        return this.hasPower();
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return this.getMaxInput();
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.hasPower() && this.getIoMode(from).canRecieveInput() ? super.receiveEnergy(from, maxReceive, simulate || this.isCreative()) : 0;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (this.isCreative()) {
            ItemStack[] invCopy = new ItemStack[this.inventory.length];
            for (int i = 0; i < this.inventory.length; ++i) {
                invCopy[i] = this.inventory[i] == null ? null : this.inventory[i].func_77946_l();
            }
            boolean ret = super.doPull(dir);
            this.inventory = invCopy;
            return ret;
        }
        return super.doPull(dir);
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (dir == null || !this.shouldDoWorkThisTick(20)) {
            return false;
        }
        if (this.isCreative()) {
            ItemStack[] invCopy = new ItemStack[this.inventory.length];
            for (int i = 0; i < this.inventory.length; ++i) {
                invCopy[i] = this.inventory[i] == null ? null : this.inventory[i].func_77946_l();
            }
            boolean ret = super.doPush(dir);
            this.inventory = invCopy;
            return ret;
        }
        return super.doPush(dir);
    }

    public boolean hasInventory() {
        return this.getType().hasInventory;
    }

    @Override
    public boolean hasPower() {
        return this.getType().hasPower;
    }

    public boolean isCreative() {
        return this.getType().isCreative;
    }

    @Override
    public boolean displayPower() {
        return this.hasPower();
    }

    public void setIO(int in, int out) {
        if (this.getCapacitorData() != DefaultCapacitorData.NONE) {
            this.maxIn = in;
            this.maxOut = out;
            this.initMaxIO();
        }
        this.func_70296_d();
    }

    public int getMaxInput() {
        return this.getCapacitorData() == DefaultCapacitorData.NONE ? 0 : this.maxIn;
    }

    public int getMaxOutput() {
        return this.getCapacitorData() == DefaultCapacitorData.NONE ? 0 : this.maxOut;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.hasPower() ? super.getMaxEnergyStored() : 0;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)(this.hasPower() ? new InternalRecieverTileWrapper(this, facingIn) : null);
        }
        return super.getCapability(capability, facingIn);
    }

    private BufferType getType() {
        return this.type;
    }

    @Storable
    public static class TileBufferCreative
    extends TileBuffer {
        public TileBufferCreative() {
            super(new SlotDefinition(9), BufferType.CREATIVE, CapacitorKey.CREATIVE_BUFFER_POWER_INTAKE, CapacitorKey.CREATIVE_BUFFER_POWER_BUFFER, CapacitorKey.CREATIVE_BUFFER_POWER_USE);
        }
    }

    @Storable
    public static class TileBufferOmni
    extends TileBuffer {
        public TileBufferOmni() {
            super(new SlotDefinition(9, 0, 1), BufferType.OMNI, CapacitorKey.BUFFER_POWER_INTAKE, CapacitorKey.BUFFER_POWER_BUFFER, CapacitorKey.BUFFER_POWER_USE);
        }
    }

    @Storable
    public static class TileBufferPower
    extends TileBuffer {
        public TileBufferPower() {
            super(new SlotDefinition(0, 0, 1), BufferType.POWER, CapacitorKey.BUFFER_POWER_INTAKE, CapacitorKey.BUFFER_POWER_BUFFER, CapacitorKey.BUFFER_POWER_USE);
        }
    }

    @Storable
    public static class TileBufferItem
    extends TileBuffer {
        public TileBufferItem() {
            super(new SlotDefinition(9), BufferType.ITEM, CapacitorKey.BUFFER_POWER_INTAKE, CapacitorKey.BUFFER_POWER_BUFFER, CapacitorKey.BUFFER_POWER_USE);
        }
    }
}

