/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.buffer;

import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.power.PoweredBlockItem;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.buffer.BufferType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BlockItemBuffer
extends PoweredBlockItem {
    public BlockItemBuffer(@Nonnull Block block) {
        super(block);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        return BlockItemBuffer.getType(stack).getUnlocalizedName();
    }

    private static BufferType getType(ItemStack stack) {
        return BufferType.getTypeFromMeta(stack.func_77952_i());
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return BlockItemBuffer.getType((ItemStack)stack).isCreative || super.func_77636_d(stack);
    }

    @Override
    public int getMaxEnergyStored(@Nonnull ItemStack stack) {
        return BlockItemBuffer.getType((ItemStack)stack).isCreative ? CapacitorKey.CREATIVE_BUFFER_POWER_BUFFER.get(DefaultCapacitorData.BASIC_CAPACITOR) : super.getMaxEnergyStored(stack);
    }

    @Override
    public int getMaxInput(@Nonnull ItemStack stack) {
        return CapacitorKey.BUFFER_POWER_INTAKE.get(DefaultCapacitorData.BASIC_CAPACITOR);
    }

    @Override
    public int getMaxOutput(@Nonnull ItemStack container) {
        return this.getMaxInput(container);
    }

    @Override
    public int getEnergyStored(@Nonnull ItemStack stack) {
        return BlockItemBuffer.getType((ItemStack)stack).isCreative ? this.getMaxEnergyStored(stack) / 2 : super.getEnergyStored(stack);
    }

    @Override
    public void setEnergyStored(@Nonnull ItemStack stack, int energy) {
        if (!BlockItemBuffer.getType((ItemStack)stack).isCreative) {
            super.setEnergyStored(stack, energy);
        }
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return BlockItemBuffer.getType((ItemStack)stack).hasPower ? super.initCapabilities(stack, nbt) : null;
    }
}

