/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.buffer;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.machine.baselegacy.AbstractPowerConsumerBlock;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.machines.machine.buffer.BlockItemBuffer;
import crazypants.enderio.machines.machine.buffer.BufferType;
import crazypants.enderio.machines.machine.buffer.ContainerBuffer;
import crazypants.enderio.machines.machine.buffer.GuiBuffer;
import crazypants.enderio.machines.machine.buffer.TileBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBuffer
extends AbstractPowerConsumerBlock<TileBuffer>
implements IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint,
ICustomSubItems {
    public static BlockBuffer create(@Nonnull IModObject modObject) {
        BlockBuffer res = new BlockBuffer(modObject);
        res.init();
        return res;
    }

    private BlockBuffer(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)).func_177226_a(BufferType.TYPE, (Comparable)((Object)BufferType.ITEM)));
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemBuffer((Block)this));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER, BufferType.TYPE});
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BufferType.TYPE, (Comparable)((Object)BufferType.getTypeFromMeta(meta)));
    }

    @Override
    public int func_176201_c(@Nonnull IBlockState state) {
        return BufferType.getMetaFromType((BufferType)((Object)state.func_177229_b(BufferType.TYPE)));
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    public int func_180651_a(@Nonnull IBlockState st) {
        return this.func_176201_c(st);
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        switch ((BufferType)((Object)state.func_177229_b(BufferType.TYPE))) {
            case CREATIVE: {
                return new TileBuffer.TileBufferCreative();
            }
            case OMNI: {
                return new TileBuffer.TileBufferOmni();
            }
            case POWER: {
                return new TileBuffer.TileBufferPower();
            }
        }
        return new TileBuffer.TileBufferItem();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        for (BufferType type : BufferType.values()) {
            list.add((Object)BufferType.getStack(type));
        }
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        return this.getSubItems((Block)this, BufferType.values().length - 1);
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileBuffer te) {
        return new ContainerBuffer(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileBuffer te) {
        return new GuiBuffer(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileBuffer tileEntity) {
        blockStateWrapper.addCacheKey(blockStateWrapper.func_177229_b((IProperty)BufferType.TYPE));
    }

    public boolean func_149740_M(@Nonnull IBlockState state) {
        return ((BufferType)((Object)state.func_177229_b(BufferType.TYPE))).hasInventory;
    }
}

