/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.alloy;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.ManyToOneMachineRecipe;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import crazypants.enderio.base.recipe.alloysmelter.VanillaSmeltingRecipe;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

@Storable
public class TileAlloySmelter
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    @Store
    @Nonnull
    protected Mode mode = Mode.ALL;

    public TileAlloySmelter() {
        this(new SlotDefinition(3, 1), CapacitorKey.ALLOY_SMELTER_POWER_INTAKE, CapacitorKey.ALLOY_SMELTER_POWER_BUFFER, CapacitorKey.ALLOY_SMELTER_POWER_USE);
    }

    protected TileAlloySmelter(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            mode = Mode.ALL;
        }
        if (this.mode != mode) {
            this.mode = mode;
            this.updateClients = true;
        }
    }

    @Override
    protected IMachineRecipe canStartNextTask(long nextSeed) {
        if (this.getMode() == Mode.FURNACE) {
            VanillaSmeltingRecipe vr = AlloyRecipeManager.getInstance().getVanillaRecipe();
            if (vr.isRecipe(this.getRecipeInputs())) {
                IPoweredTask task = this.createTask(vr, nextSeed);
                if (task == null) {
                    return null;
                }
                IMachineRecipe.ResultStack[] res = task.getCompletedResult();
                if (res.length == 0) {
                    return null;
                }
                return this.canInsertResult(nextSeed, vr) ? vr : null;
            }
            return null;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (this.getMode() == Mode.ALLOY && nextRecipe instanceof VanillaSmeltingRecipe) {
            nextRecipe = null;
        }
        if (nextRecipe == null) {
            return null;
        }
        return this.canInsertResult(nextSeed, nextRecipe) ? nextRecipe : null;
    }

    @Override
    public boolean isMachineItemValidForSlot(int slot, @Nonnull ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        ItemStack currentStackInSlot = (ItemStack)NullHelper.first((Object[])new ItemStack[]{this.inventory[slot], Prep.getEmpty()});
        if (Prep.isValid(currentStackInSlot)) {
            return currentStackInSlot.func_77969_a(itemstack);
        }
        int numSlotsFilled = 0;
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (i < 0 || i >= this.inventory.length || this.inventory[i] == null || this.inventory[i].func_190916_E() <= 0) continue;
            ++numSlotsFilled;
        }
        NNList<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), MachineRecipeInput.create(slot, itemstack));
        if (this.getMode() == Mode.FURNACE) {
            return this.isValidInputForFurnaceRecipe(itemstack, numSlotsFilled, recipes);
        }
        if (this.getMode() == Mode.ALLOY) {
            return this.isValidInputForAlloyRecipe(slot, itemstack, numSlotsFilled, recipes);
        }
        return this.isValidInputForFurnaceRecipe(itemstack, numSlotsFilled, recipes) || this.isValidInputForAlloyRecipe(slot, itemstack, numSlotsFilled, recipes);
    }

    private boolean isValidInputForAlloyRecipe(int slot, @Nonnull ItemStack itemstack, int numSlotsFilled, NNList<IMachineRecipe> recipes) {
        if (numSlotsFilled == 0) {
            return this.containsAlloyRecipe(recipes);
        }
        for (IMachineRecipe recipe : recipes) {
            if (recipe instanceof VanillaSmeltingRecipe) continue;
            if (recipe instanceof ManyToOneMachineRecipe) {
                ItemStack[] resultInv = new ItemStack[this.slotDefinition.getNumInputSlots()];
                for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
                    if (i < 0 || i >= this.inventory.length) continue;
                    resultInv[i] = i == slot ? itemstack : this.inventory[i];
                }
                if (!((ManyToOneMachineRecipe)recipe).isValidRecipeComponents(resultInv)) continue;
                return true;
            }
            Log.warn("TileAlloySmelter.isMachineItemValidForSlot: A non alloy recipe was returned for the alloy smelter");
            return true;
        }
        return false;
    }

    private boolean isValidInputForFurnaceRecipe(@Nonnull ItemStack itemstack, int numSlotsFilled, NNList<IMachineRecipe> recipes) {
        if (numSlotsFilled == 0) {
            return this.containsFurnaceRecipe(recipes);
        }
        return this.containsFurnaceRecipe(recipes) && this.isItemAlreadyInASlot(itemstack);
    }

    private boolean isItemAlreadyInASlot(@Nonnull ItemStack itemstack) {
        ItemStack currentStackType = null;
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot() && currentStackType == null; ++i) {
            currentStackType = this.inventory[i];
            if (currentStackType == null || !currentStackType.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFurnaceRecipe(NNList<IMachineRecipe> recipes) {
        for (IMachineRecipe rec : recipes) {
            if (!(rec instanceof VanillaSmeltingRecipe)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAlloyRecipe(NNList<IMachineRecipe> recipes) {
        for (IMachineRecipe rec : recipes) {
            if (rec instanceof VanillaSmeltingRecipe) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "alloysmelter";
    }

    public static enum Mode {
        ALL,
        ALLOY,
        FURNACE;


        Mode next() {
            int nextOrd = this.ordinal() + 1;
            if (nextOrd >= Mode.values().length) {
                nextOrd = 0;
            }
            return Mode.values()[nextOrd];
        }

        Mode prev() {
            int nextOrd = this.ordinal() - 1;
            if (nextOrd < 0) {
                nextOrd = Mode.values().length - 1;
            }
            return Mode.values()[nextOrd];
        }
    }

    public static class Simple
    extends TileAlloySmelter {
        public Simple() {
            super(new SlotDefinition(3, 1, 0), CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_INTAKE, CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_BUFFER, CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_USE);
            this.setEnergyLoss(CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_LOSS);
            this.mode = Mode.ALLOY;
        }

        @Override
        @Nonnull
        public Mode getMode() {
            return Mode.ALLOY;
        }
    }
}

