/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.alloy;

import com.enderio.core.client.gui.button.IIconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.alloy.BlockAlloySmelter;
import crazypants.enderio.machines.machine.alloy.ContainerAlloySmelter;
import crazypants.enderio.machines.machine.alloy.IAlloySmelterRemoteExec;
import crazypants.enderio.machines.machine.alloy.TileAlloySmelter;
import java.awt.Rectangle;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.util.SoundEvent;

public class GuiAlloySmelter<T extends TileAlloySmelter>
extends GuiInventoryMachineBase<T>
implements IAlloySmelterRemoteExec.GUI {
    @Nonnull
    private final IIconButton vanillaFurnaceButton;
    @Nonnull
    private final GuiToolTip vanillaFurnaceTooltip;
    private final boolean isSimple;
    protected static final int SMELT_MODE_BUTTON_ID = 76;

    public GuiAlloySmelter(@Nonnull InventoryPlayer par1InventoryPlayer, @Nonnull T furnaceInventory) {
        super(furnaceInventory, (Container)ContainerAlloySmelter.create(par1InventoryPlayer, furnaceInventory), "alloy_smelter", "simple_alloy_smelter");
        this.isSimple = furnaceInventory instanceof TileAlloySmelter.Simple;
        this.vanillaFurnaceButton = new IIconButton(this.getFontRenderer(), 76, 0, 0, null, RenderUtil.BLOCK_TEX);
        this.vanillaFurnaceButton.setSize(16, 16);
        this.vanillaFurnaceButton.field_146125_m = !this.isSimple;
        this.vanillaFurnaceTooltip = new GuiToolTip(new Rectangle(this.field_146999_f - 5 - 16, 62, 16, 16), (String[])null);
        this.vanillaFurnaceTooltip.setIsVisible(!this.isSimple);
        this.redstoneButton.setIsVisible(!this.isSimple);
        this.addProgressTooltip(55, 35, 14, 14);
        this.addProgressTooltip(103, 35, 14, 14);
        this.addDrawingElement(new PowerBar((IPowerBarData)furnaceInventory, this));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.vanillaFurnaceButton.field_146128_h = this.field_147003_i + this.vanillaFurnaceTooltip.getBounds().x;
        this.vanillaFurnaceButton.field_146129_i = this.field_147009_r + this.vanillaFurnaceTooltip.getBounds().y;
        this.field_146292_n.add(this.vanillaFurnaceButton);
        this.addToolTip(this.vanillaFurnaceTooltip);
        this.updateVanillaFurnaceButton();
    }

    @Override
    protected void renderSlotHighlight(int slot, @Nonnull Vector4f col) {
        if (((TileAlloySmelter)this.getTileEntity()).getSlotDefinition().isOutputSlot(slot)) {
            this.renderSlotHighlight(col, 75, 54, 24, 24);
        } else {
            super.renderSlotHighlight(slot, col);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        if (button == 1 && this.vanillaFurnaceButton.func_146115_a() && !this.isSimple) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.actionPerformed((GuiButton)this.vanillaFurnaceButton, 1);
        }
        super.func_73864_a(x, y, button);
    }

    protected void func_146284_a(@Nonnull GuiButton par1GuiButton) throws IOException {
        this.actionPerformed(par1GuiButton, 0);
    }

    private void actionPerformed(GuiButton button, int mbutton) throws IOException {
        if (button.field_146127_k == 76) {
            ((TileAlloySmelter)this.getTileEntity()).setMode(mbutton == 0 ? ((TileAlloySmelter)this.getTileEntity()).getMode().next() : ((TileAlloySmelter)this.getTileEntity()).getMode().prev());
            this.updateVanillaFurnaceButton();
            this.doSetMode(((TileAlloySmelter)this.getTileEntity()).getMode());
        } else {
            super.func_146284_a(button);
        }
    }

    private void updateVanillaFurnaceButton() {
        TextureAtlasSprite icon = BlockAlloySmelter.vanillaSmeltingOn.get(TextureAtlasSprite.class);
        Lang unlocText = Lang.GUI_ALLOY_MODE_ALL;
        if (((TileAlloySmelter)this.getTileEntity()).getMode() == TileAlloySmelter.Mode.ALLOY) {
            icon = BlockAlloySmelter.vanillaSmeltingOff.get(TextureAtlasSprite.class);
            unlocText = Lang.GUI_ALLOY_MODE_ALLOY;
        } else if (((TileAlloySmelter)this.getTileEntity()).getMode() == TileAlloySmelter.Mode.FURNACE) {
            icon = BlockAlloySmelter.vanillaSmeltingOnly.get(TextureAtlasSprite.class);
            unlocText = Lang.GUI_ALLOY_MODE_FURNACE;
        }
        this.vanillaFurnaceButton.setIcon(icon);
        this.vanillaFurnaceTooltip.setToolTipText(new String[]{Lang.GUI_ALLOY_MODE.get(), unlocText.get()});
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture(this.isSimple ? 1 : 0);
        int sx = this.field_147003_i;
        int sy = this.field_147009_r;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.shouldRenderProgress()) {
            int scaled = this.getProgressScaled(14) + 1;
            this.func_73729_b(sx + 55, sy + 49 - scaled, 176, 14 - scaled, 14, scaled);
            this.func_73729_b(sx + 103, sy + 49 - scaled, 176, 14 - scaled, 14, scaled);
        }
        super.func_146976_a(par1, par2, par3);
    }
}

