/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.AbstractPainterTemplate;
import crazypants.enderio.machines.config.config.ClientConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.painter.ContainerPainter;
import crazypants.enderio.machines.machine.painter.GuiPainter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PainterRecipeCategory
extends BlankRecipeCategory<PainterRecipeWrapper> {
    @Nonnull
    public static final String UID = "Painter";
    private static final int xOff = 34;
    private static final int yOff = 28;
    @Nonnull
    private final IStackHelper stackHelper;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawableAnimated arrow;

    @Nonnull
    private static List<PainterRecipeWrapper> splitRecipes(@Nonnull Collection<IMachineRecipe> recipes, List<ItemStack> validItems) {
        long start = System.nanoTime();
        ArrayList<AbstractPainterTemplate> basicPainterTemplates = new ArrayList<AbstractPainterTemplate>();
        for (IMachineRecipe iMachineRecipe : recipes) {
            if (!(iMachineRecipe instanceof AbstractPainterTemplate)) continue;
            basicPainterTemplates.add((AbstractPainterTemplate)iMachineRecipe);
        }
        ArrayList<PainterRecipeWrapper> recipesWrappers = new ArrayList<PainterRecipeWrapper>();
        for (ItemStack target : validItems) {
            for (AbstractPainterTemplate basicPainterTemplate : basicPainterTemplates) {
                if (!basicPainterTemplate.isValidTarget(target)) continue;
                recipesWrappers.add(new PainterRecipeWrapper(basicPainterTemplate, target, new ArrayList<ItemStack>(), new ArrayList<ItemStack>()));
            }
        }
        List<ItemStack> list = ClientConfig.jeiUseShortenedPainterRecipes.get() != false ? PainterRecipeCategory.getLimitedItems(validItems) : validItems;
        int count = 0;
        for (ItemStack paint : list) {
            try {
                for (PainterRecipeWrapper painterRecipeWrapper : recipesWrappers) {
                    if (!painterRecipeWrapper.recipe.isRecipe(paint, painterRecipeWrapper.target)) continue;
                    for (IMachineRecipe.ResultStack result : painterRecipeWrapper.recipe.getCompletedResult(paint, painterRecipeWrapper.target)) {
                        painterRecipeWrapper.results.add(result.item);
                        painterRecipeWrapper.paints.add(paint);
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                Log.warn("PainterRecipeCategory: Error while accessing item '" + paint + "': " + e);
                e.printStackTrace();
            }
        }
        long end = System.nanoTime();
        for (PainterRecipeWrapper painterRecipeWrapper : recipesWrappers) {
            if (!painterRecipeWrapper.results.isEmpty()) continue;
            Log.warn("PainterRecipeCategory: Empty recipe group: " + painterRecipeWrapper.recipe + " for " + painterRecipeWrapper.target);
        }
        Log.info(String.format("PainterRecipeCategory: Added %d painter recipes in %d groups to JEI in %.3f seconds.", count, recipesWrappers.size(), (double)(end - start) / 1.0E9));
        return recipesWrappers;
    }

    public static void register(IModRegistry registry, IJeiHelpers jeiHelpers) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PainterRecipeCategory(jeiHelpers)});
        registry.addRecipeClickArea(GuiPainter.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_painter.getBlock()), new String[]{UID});
        List validItems = registry.getIngredientRegistry().getIngredients(ItemStack.class);
        registry.addRecipes(PainterRecipeCategory.splitRecipes(MachineRecipeRegistry.instance.getRecipesForMachine("painter").values(), validItems), UID);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerPainter.class, UID, ContainerPainter.FIRST_RECIPE_SLOT, ContainerPainter.NUM_RECIPE_SLOT, ContainerPainter.FIRST_INVENTORY_SLOT, ContainerPainter.NUM_INVENTORY_SLOT);
    }

    public PainterRecipeCategory(IJeiHelpers jeiHelpers) {
        this.stackHelper = jeiHelpers.getStackHelper();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("painter");
        this.background = guiHelper.createDrawable(backgroundLocation, 34, 28, 120, 50);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 176, 14, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_painter.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 54, 6);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull PainterRecipeWrapper currentRecipe, @Nonnull IIngredients ingredients) {
        Object focusValue;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 32, 5);
        guiItemStacks.init(1, true, 3, 5);
        guiItemStacks.init(2, false, 86, 5);
        group.init(3, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 74, 32, 50, 10, 0, 0);
        IFocus focus = recipeLayout.getFocus();
        if (focus != null && (focusValue = focus.getValue()) instanceof ItemStack) {
            ItemStack focused = (ItemStack)focusValue;
            ArrayList<ItemStack> paints = new ArrayList<ItemStack>();
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            if (focus.getMode() == IFocus.Mode.OUTPUT) {
                IBlockState paint = PaintUtil.getSourceBlock(focused);
                ItemStack paintAsStack = PaintUtil.getPaintAsStack(paint);
                paints.add(paintAsStack);
                results.add(focused);
            } else if (this.stackHelper.isEquivalent(focused, currentRecipe.target)) {
                for (int i = 0; i < currentRecipe.paints.size(); ++i) {
                    ItemStack resultStack = currentRecipe.results.get(i);
                    ItemStack paintStack = currentRecipe.paints.get(i);
                    if (this.stackHelper.isEquivalent(focused, paintStack)) continue;
                    paints.add(paintStack);
                    results.add(resultStack);
                }
            } else {
                for (IMachineRecipe.ResultStack result : currentRecipe.recipe.getCompletedResult(focused, currentRecipe.target)) {
                    paints.add(focused);
                    results.add(result.item);
                }
            }
            if (!paints.isEmpty()) {
                guiItemStacks.set(1, paints);
                guiItemStacks.set(2, results);
                return;
            }
        }
        guiItemStacks.set(0, currentRecipe.target);
        guiItemStacks.set(1, currentRecipe.paints);
        guiItemStacks.set(2, currentRecipe.results);
        group.set(ingredients);
    }

    @Nonnull
    private static List<ItemStack> getLimitedItems(List<ItemStack> validItems) {
        Things paints = new Things().add(Blocks.field_150348_b).add(Blocks.field_150347_e).add((Block)Blocks.field_150349_c).add(Blocks.field_150346_d).add(Blocks.field_150344_f).add(Blocks.field_150359_w).add(Blocks.field_150446_ar).add((Block)Blocks.field_150328_O).add(Blocks.field_180399_cE).add(Blocks.field_150335_W);
        Random rand = new Random();
        for (ItemStack stack : validItems) {
            if (!(rand.nextFloat() < 0.05f) || paints.contains(stack)) continue;
            paints.add(stack);
        }
        NNList paintStacks = paints.getItemStacks();
        while (paintStacks.size() > 50) {
            paintStacks.remove(paintStacks.size() - 1);
        }
        return paintStacks;
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class PainterRecipeWrapper
    extends BlankRecipeWrapper {
        final AbstractPainterTemplate<?> recipe;
        @Nonnull
        final ItemStack target;
        @Nonnull
        final List<ItemStack> paints;
        @Nonnull
        final List<ItemStack> results;

        public PainterRecipeWrapper(@Nonnull AbstractPainterTemplate<?> recipe, @Nonnull ItemStack target, @Nonnull List<ItemStack> paints, @Nonnull List<ItemStack> results) {
            this.recipe = recipe;
            this.target = target;
            this.paints = paints;
            this.results = results;
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
            list.add(Collections.singletonList(this.target));
            list.add(this.paints);
            ingredients.setInputLists(ItemStack.class, list);
            ingredients.setOutputs(ItemStack.class, this.results);
            ingredients.setInput(EnergyIngredient.class, (Object)new EnergyIngredient(this.recipe.getEnergyRequired((NNList<MachineRecipeInput>)NNList.emptyList())));
        }
    }
}

