/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.api.client.render.IWidgetIcon;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.RecipeWrapper;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.alloy.ContainerAlloySmelter;
import crazypants.enderio.machines.machine.alloy.GuiAlloySmelter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AlloyRecipeCategory
extends BlankRecipeCategory<AlloyRecipeWrapper> {
    @Nonnull
    public static final String UID = "AlloySmelter";
    private static final int xOff = 45;
    private static final int yOff = 3;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawableAnimated flame;

    public static void register(IModRegistry registry, @Nonnull IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyRecipeCategory(guiHelper)});
        registry.addRecipeClickArea(GuiAlloySmelter.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_alloy_smelter.getBlockNN()), new String[]{UID, "minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_simple_alloy_smelter.getBlockNN()), new String[]{UID});
        long start = System.nanoTime();
        ArrayList<AlloyRecipeWrapper> result = new ArrayList<AlloyRecipeWrapper>();
        for (IRecipe rec : AlloyRecipeManager.getInstance().getRecipes()) {
            if (rec.isSynthetic()) continue;
            result.add(new AlloyRecipeWrapper(rec, guiHelper));
        }
        for (IRecipe rec : AlloyRecipeManager.getInstance().getVanillaRecipe().getAllRecipes()) {
            result.add(new AlloyRecipeWrapper(rec, guiHelper));
        }
        long end = System.nanoTime();
        registry.addRecipes(result, UID);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAlloySmelter.Normal.class, UID, ContainerAlloySmelter.FIRST_RECIPE_SLOT, ContainerAlloySmelter.NUM_RECIPE_SLOT, ContainerAlloySmelter.FIRST_INVENTORY_SLOT, ContainerAlloySmelter.NUM_INVENTORY_SLOT);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAlloySmelter.Simple.class, UID, ContainerAlloySmelter.FIRST_RECIPE_SLOT, ContainerAlloySmelter.NUM_RECIPE_SLOT, ContainerAlloySmelter.FIRST_INVENTORY_SLOT - 1, ContainerAlloySmelter.NUM_INVENTORY_SLOT);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAlloySmelter.Normal.class, "minecraft.smelting", ContainerAlloySmelter.FIRST_RECIPE_SLOT, ContainerAlloySmelter.NUM_RECIPE_SLOT, ContainerAlloySmelter.FIRST_INVENTORY_SLOT, ContainerAlloySmelter.NUM_INVENTORY_SLOT);
        Log.info(String.format("AlloyRecipeCategory: Added %d alloy smelter recipes to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9));
    }

    public AlloyRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("alloy_smelter");
        this.background = guiHelper.createDrawable(backgroundLocation, 45, 3, 82, 78);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 176, 0, 13, 13);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_alloy_smelter.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 11, 33);
        this.flame.draw(minecraft, 58, 33);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AlloyRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 8, 13);
        guiItemStacks.init(1, true, 33, 3);
        guiItemStacks.init(2, true, 57, 13);
        guiItemStacks.init(3, false, 33, 54);
        group.init(4, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 63, 52, 50, 10, 0, 0);
        List inputs = ingredients.getInputs(ItemStack.class);
        for (int index = 0; index < inputs.size(); ++index) {
            List input = (List)inputs.get(index);
            if (input == null) continue;
            guiItemStacks.set(index, input);
        }
        List outputs = ingredients.getOutputs(ItemStack.class);
        guiItemStacks.set(3, (List)outputs.get(0));
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class AlloyRecipeWrapper
    extends RecipeWrapper {
        private IDrawable alloyFront;

        public AlloyRecipeWrapper(IRecipe recipe, @Nonnull IGuiHelper guiHelper) {
            super(recipe);
            if (!IRecipe.RecipeLevel.SIMPLE.is(recipe.getRecipeLevel())) {
                this.alloyFront = guiHelper.createDrawable(new ResourceLocation("enderio", "textures/blocks/alloy_smelter_simple_front.png"), 0, 0, 16, 16, 16, 16);
            }
        }

        @Override
        public void getIngredients(@Nonnull IIngredients ingredients) {
            super.getIngredients(ingredients);
            ingredients.setInput(EnergyIngredient.class, (Object)new EnergyIngredient(this.recipe.getEnergyRequired()));
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.alloyFront != null) {
                this.alloyFront.draw(minecraft, 84, 32);
                IconEIO.map.render((IWidgetIcon)IconEIO.GENERIC_VERBOTEN, 90.0, 26.0, true);
            }
        }

        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (this.alloyFront != null && mouseX >= 76 && mouseX <= 108 && mouseY >= 24 && mouseY <= 56) {
                return Lang.JEI_ALLOY_NOTSIMPLE.getLines(new Object[0]);
            }
            return super.getTooltipStrings(mouseX, mouseY);
        }
    }
}

