/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.config.config;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.config.factory.IValueFactory;
import crazypants.enderio.machines.config.Config;
import java.util.Locale;
import javax.annotation.Nonnull;

public final class ClientConfig {
    public static final IValueFactory F = Config.F.section("client");
    public static final IValue<Boolean> jeiUseShortenedPainterRecipes = F.make("jeiUseShortenedPainterRecipes", true, "If true, only a handful of sample painter recipes will be shown in JEI. Enable this if you have timing problems starting a world or logging into a server.");
    public static final IValue<Boolean> machineSoundsEnabled = PersonalConfig.machineSoundsEnabled;
    public static final IValue<Float> machineSoundVolume = PersonalConfig.machineSoundsVolume;
    public static final IValue<Boolean> bloodEnabled = new IValue<Boolean>(){
        private final IValue<Integer> bloodEnabledInt = F.make("bloodEnabled", 0, "Should blood be red or green? (-1=green, 0=auto, 1=red)").setRange(-1.0, 1.0);
        private boolean hasLogged = false;

        @Override
        @Nonnull
        public Boolean get() {
            boolean overrideNeeded = Locale.getDefault().getCountry().equals(Locale.GERMANY.getCountry());
            Integer value = this.bloodEnabledInt.get();
            if (overrideNeeded && value == 0) {
                if (!this.hasLogged) {
                    Log.warn("Detected local country '" + Locale.getDefault().getCountry() + "', cencoring blood.");
                    this.hasLogged = true;
                }
                return false;
            }
            return value > 0;
        }
    };
}

