/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.config;

import com.enderio.core.common.event.ConfigFileChangedEvent;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.Config;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderiomachines")
public class ConfigHandler {
    public static Configuration config;

    @Nonnull
    public static File getConfigDirectory() {
        return (File)NullHelper.notnull((Object)ConfigHandler.getConfigDirectoryRaw(), (String)"Ender IO configuration failed");
    }

    public static File getConfigDirectoryRaw() {
        return crazypants.enderio.base.config.Config.configDirectory;
    }

    public static void init(FMLPreInitializationEvent event) {
        File configDirectory = ConfigHandler.getConfigDirectoryRaw();
        if (configDirectory == null) {
            Log.warn("Ender IO Machines was initialized before Ender IO. This should not happen.");
            crazypants.enderio.base.config.Config.init(event);
            configDirectory = ConfigHandler.getConfigDirectory();
        }
        File configFile = new File(configDirectory, "enderiomachines.cfg");
        config = new Configuration(configFile);
        ConfigHandler.syncConfig(false);
    }

    public static void syncConfig(boolean load) {
        try {
            if (load) {
                config.load();
            }
            ConfigHandler.processConfig();
        }
        catch (Exception e) {
            Log.error("Ender IO Machines has a problem loading its configuration:");
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("enderiomachines") || event.getModID().equals("enderio")) {
            Log.info("Updating config...");
            ConfigHandler.syncConfig(false);
        }
    }

    @SubscribeEvent
    public static void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.getModID().equals("enderiomachines")) {
            Log.info("Updating config...");
            ConfigHandler.syncConfig(true);
            event.setSuccessful();
        }
    }

    private static void processConfig() {
        Config.load();
        Config.F.setConfig(config);
        CapacitorKey.processConfig(config);
    }
}

