/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic.recipes;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.integration.tic.queues.BasinQueue;
import crazypants.enderio.integration.tic.queues.CastQueue;
import crazypants.enderio.integration.tic.queues.SmeltQueue;
import crazypants.enderio.integration.tic.queues.TiCQueues;
import crazypants.enderio.integration.tic.queues.TicHandler;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

public class TicRegistration {
    private static void registerAlloyRecipe(Pair<Things, NNList<Things>> alloy) {
        Things result = (Things)NullHelper.notnull((Object)alloy.getLeft(), (String)"missing result item stack in alloy recipe");
        NNList input = (NNList)alloy.getRight();
        FluidStack fluidResult = TicRegistration.getFluidForItems(result);
        if (fluidResult == null) {
            TicRegistration.tryBasinAloying(result, (NNList<Things>)input);
            return;
        }
        FluidStack[] fluids = new FluidStack[input.size()];
        ArrayList<String> debug = new ArrayList<String>();
        for (int i = 0; i < input.size(); ++i) {
            fluids[i] = TicRegistration.getFluidForItems((Things)NullHelper.notnull((Object)input.get(i), (String)"missing input item stack in alloy recipe"));
            if (fluids[i] == null) {
                return;
            }
            debug.add(TicRegistration.toString(fluids[i]));
        }
        TicRegistration.gcd(fluidResult, fluids);
        TinkerRegistry.registerAlloy((FluidStack)fluidResult, (FluidStack[])fluids);
        Log.debug("Tinkers.registerAlloy: " + TicRegistration.toString(fluidResult) + ", " + debug);
    }

    private static void tryBasinAloying(@Nonnull Things result, NNList<Things> inputs) {
        FluidStack b;
        if (!result.isValid() || result.getItemStack().func_190916_E() != 1 || !(result.getItemStack().func_77973_b() instanceof ItemBlock) || inputs.size() != 2) {
            return;
        }
        Things input0 = (Things)inputs.get(0);
        Things input1 = (Things)inputs.get(1);
        if (!input0.isValid() || !input1.isValid()) {
            return;
        }
        FluidStack a = TicRegistration.getFluidForItems(input0);
        if (a == null == ((b = TicRegistration.getFluidForItems(input1)) == null)) {
            return;
        }
        if (!(a != null || input0.getItemStack().func_190916_E() == 1 && input0.getItemStack().func_77973_b() instanceof ItemBlock)) {
            return;
        }
        if (!(b != null || input1.getItemStack().func_190916_E() == 1 && input1.getItemStack().func_77973_b() instanceof ItemBlock)) {
            return;
        }
        if (a != null) {
            TicHandler.instance.registerBasinCasting(result, input1, a.getFluid(), a.amount);
        } else if (b != null) {
            TicHandler.instance.registerBasinCasting(result, input0, b.getFluid(), b.amount);
        }
    }

    public static void registerBasinCasting() {
        for (BasinQueue basin : TiCQueues.getBasinQueue()) {
            FluidStack fluid;
            if (basin.getFluid() == null && (fluid = TicRegistration.getFluidForItems(basin.getFluidItem())) != null) {
                basin.setFluid(fluid.getFluid());
                basin.setAmount(basin.getAmount() * (float)fluid.amount);
            }
            if (basin.getFluid() == null) {
                Log.warn("Item used in basin cast recipe '" + TicRegistration.toString(basin.getFluidItem()) + "' doesn't smelt into a fluid");
            }
            if (!basin.getOutput().isValid()) {
                Log.warn("Item used in basin cast recipe '" + TicRegistration.toString(basin.getOutput()) + "' doesn't exist");
            }
            if (!basin.getCast().isEmpty()) {
                NNList.NNIterator itr = basin.getCast().getItemStacks().fastIterator();
                while (itr.hasNext()) {
                    ItemStack castStack = (ItemStack)itr.next();
                    TinkerRegistry.registerBasinCasting((ItemStack)basin.getOutput().getItemStack(), (ItemStack)castStack, (Fluid)basin.getFluid(), (int)((int)Math.ceil(basin.getAmount())));
                    Log.debug("Tinkers.registerBasinCasting: " + TicRegistration.toString(basin.getOutput()) + ", " + TicRegistration.toString(castStack) + ", " + basin.getFluid().getName() + ", " + basin.getAmount());
                }
                continue;
            }
            TinkerRegistry.registerBasinCasting((ItemStack)basin.getOutput().getItemStack(), (ItemStack)Prep.getEmpty(), (Fluid)basin.getFluid(), (int)((int)Math.ceil(basin.getAmount())));
            Log.debug("Tinkers.registerBasinCasting: " + TicRegistration.toString(basin.getOutput()) + ", (empty), " + basin.getFluid().getName() + ", " + basin.getAmount());
        }
        TiCQueues.getBasinQueue().clear();
    }

    public static void registerTableCasting() {
        for (CastQueue cast : TiCQueues.getCastQueue()) {
            FluidStack fluid;
            if (cast.getFluid() == null && (fluid = TicRegistration.getFluidForItems(cast.getItem())) != null) {
                cast.setFluid(fluid.getFluid());
                cast.setAmount(cast.getAmount() * (float)fluid.amount);
            }
            if (cast.getFluid() == null) {
                Log.warn("Item used in cast recipe '" + TicRegistration.toString(cast.getItem()) + "' doesn't smelt into a fluid");
                continue;
            }
            if (!cast.getResult().isValid()) {
                Log.warn("Item used in cast recipe '" + TicRegistration.toString(cast.getResult()) + "' doesn't exist");
                continue;
            }
            if (!cast.getCast().isEmpty()) {
                NNList.NNIterator itr = cast.getCast().getItemStacks().fastIterator();
                while (itr.hasNext()) {
                    ItemStack castStack = (ItemStack)itr.next();
                    TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(cast.getResult().getItemStack(), RecipeMatch.ofNBT((ItemStack)castStack), cast.getFluid(), (int)Math.ceil(cast.getAmount()), cast.isConsumeCast(), false));
                    Log.debug("Tinkers.registerTableCasting: " + TicRegistration.toString(cast.getResult()) + ", " + TicRegistration.toString(castStack) + ", " + cast.getFluid().getName() + ", " + cast.getAmount());
                }
                continue;
            }
            TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(cast.getResult().getItemStack(), null, cast.getFluid(), (int)Math.ceil(cast.getAmount()), cast.isConsumeCast(), false));
            Log.debug("Tinkers.registerTableCasting: " + TicRegistration.toString(cast.getResult()) + ", (no cast), " + cast.getFluid().getName() + ", " + cast.getAmount());
        }
        TiCQueues.getCastQueue().clear();
    }

    public static void registerAlloys() {
        for (Pair<Things, NNList<Things>> alloy : TiCQueues.getAlloyQueue()) {
            TicRegistration.registerAlloyRecipe(alloy);
        }
        TiCQueues.getAlloyQueue().clear();
    }

    public static void registerSmeltings() {
        for (SmeltQueue smelt : TiCQueues.getSmeltQueue()) {
            if (smelt.getFluidOutput() == null) {
                FluidStack fluid = TicRegistration.getFluidForItems(smelt.getOutput());
                if (fluid == null) {
                    Log.warn("Item used in Smeltery recipe '" + TicRegistration.toString(smelt.getOutput()) + "' doesn't smelt into a fluid");
                } else {
                    smelt.setFluidOutput(fluid.getFluid());
                    smelt.setAmount(smelt.getAmount() * (float)fluid.amount);
                }
            }
            if (smelt.getFluidOutput() == null) continue;
            for (ItemStack in : smelt.getInput().getItemStacks()) {
                TinkerRegistry.registerMelting((ItemStack)in, (Fluid)smelt.getFluidOutput(), (int)((int)Math.max(1.0, Math.floor(smelt.getAmount()))));
                Log.debug("Tinkers.registerMelting: " + TicRegistration.toString(in) + ", " + smelt.getFluidOutput().getName() + ", " + smelt.getAmount());
            }
        }
        TiCQueues.getSmeltQueue().clear();
    }

    private static int gcd(int a, int b) {
        while (b > 0) {
            int temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    private static void gcd(FluidStack input, FluidStack ... inputs) {
        int result = input.amount;
        for (FluidStack stack : inputs) {
            result = TicRegistration.gcd(result, stack.amount);
        }
        if (result > 1) {
            input.amount /= result;
            for (FluidStack stack : inputs) {
                stack.amount /= result;
            }
        }
    }

    private static FluidStack getFluidForItems(@Nonnull ItemStack input) {
        ItemStack itemStack = input.func_77946_l();
        itemStack.func_190920_e(1);
        MeltingRecipe melting = TinkerRegistry.getMelting((ItemStack)itemStack);
        if (melting == null) {
            Fluid fluid;
            if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150343_Z) && (fluid = FluidRegistry.getFluid((String)"obsidian")) != null) {
                return new FluidStack(fluid, 288 * input.func_190916_E());
            }
            Log.debug("Failed to get Tinker's Construct melting recipe for " + TicRegistration.toString(itemStack));
            return null;
        }
        FluidStack result = melting.getResult();
        if (result != null) {
            result.amount *= input.func_190916_E();
            return result;
        }
        Log.info("Failed to get Tinker's Construct melting recipe result for " + TicRegistration.toString(itemStack) + " -> " + TicRegistration.toString(result));
        return null;
    }

    private static FluidStack getFluidForItems(Things item) {
        if (item != null) {
            NNList itemStacks = item.getItemStacks();
            NNList.NNIterator itr = itemStacks.fastIterator();
            while (itr.hasNext()) {
                FluidStack fluidStack = TicRegistration.getFluidForItems((ItemStack)itr.next());
                if (fluidStack == null) continue;
                return fluidStack;
            }
        }
        return null;
    }

    @Nonnull
    private static String toString(Things o) {
        return o == null || o.isEmpty() ? "(empty)" : o + " (" + TicRegistration.toString((List<ItemStack>)o.getItemStacks()) + ")";
    }

    @Nonnull
    private static String toString(@Nonnull List<ItemStack> o) {
        NNList result = new NNList();
        for (ItemStack itemStack : o) {
            result.add(TicRegistration.toString(itemStack));
        }
        return "" + result.toString();
    }

    @Nonnull
    private static String toString(ItemStack o) {
        return o == null || Prep.isInvalid(o) ? "(empty)" : o + " (" + o.func_82833_r() + ")";
    }

    @Nonnull
    private static String toString(FluidStack o) {
        return o == null ? "(null)" : o + " (" + o.getLocalizedName() + ")";
    }
}

