/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry.init;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.init.IModObject;
import crazypants.enderio.base.init.IModTileEntity;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.integration.forestry.filters.ItemSpeciesItemFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;

public enum ForestryIntegrationObject implements IModObject.Registerable
{
    itemSpeciesItemFilter(ItemSpeciesItemFilter.class);

    @Nonnull
    final String unlocalisedName = ModObjectRegistry.sanitizeName((String)NullHelper.notnullJ((Object)this.name(), (String)"Enum.name()"));
    @Nullable
    protected Block block;
    @Nullable
    protected Item item;
    @Nonnull
    protected final Class<?> clazz;
    @Nullable
    protected final String blockMethodName;
    @Nullable
    protected final String itemMethodName;
    @Nullable
    protected final IModTileEntity modTileEntity;

    public static void registerBlocksEarly(@Nonnull RegistryEvent.Register<Block> event) {
        ModObjectRegistry.addModObjects(ForestryIntegrationObject.class);
    }

    private ForestryIntegrationObject(Class<?> clazz) {
        this(clazz, (IModTileEntity)null);
    }

    private ForestryIntegrationObject(Class<?> clazz, IModTileEntity modTileEntity) {
        this(clazz, "create", modTileEntity);
    }

    private ForestryIntegrationObject(Class<?> clazz, String methodName) {
        this(clazz, Block.class.isAssignableFrom(clazz) ? methodName : null, Item.class.isAssignableFrom(clazz) ? methodName : null, null);
    }

    private ForestryIntegrationObject(@Nullable Class<?> clazz, String methodName, IModTileEntity modTileEntity) {
        this.clazz = clazz;
        if (Block.class.isAssignableFrom(clazz)) {
            this.blockMethodName = methodName;
            this.itemMethodName = null;
        } else if (Item.class.isAssignableFrom(clazz)) {
            this.blockMethodName = null;
            this.itemMethodName = methodName;
        } else {
            throw new RuntimeException("Clazz " + clazz + " unexpectedly is neither a Block nor an Item.");
        }
        this.modTileEntity = modTileEntity;
    }

    private ForestryIntegrationObject(@Nullable Class<?> clazz, @Nullable String blockMethodName, String itemMethodName, IModTileEntity modTileEntity) {
        this.clazz = clazz;
        this.blockMethodName = blockMethodName == null || blockMethodName.isEmpty() ? null : blockMethodName;
        this.itemMethodName = itemMethodName == null || itemMethodName.isEmpty() ? null : itemMethodName;
        this.modTileEntity = modTileEntity;
    }

    @Override
    @Nonnull
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public void setItem(@Nullable Item obj) {
        this.item = obj;
    }

    @Override
    public void setBlock(@Nullable Block obj) {
        this.block = obj;
    }

    @Override
    @Nonnull
    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("enderio", this.getUnlocalisedName());
    }

    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Nullable
    public Item getItem() {
        return this.item;
    }

    @Override
    @Nullable
    public IModTileEntity getTileEntity() {
        return this.modTileEntity;
    }

    @Override
    @Nonnull
    public final <B extends Block> B apply(@Nonnull B blockIn) {
        blockIn.func_149663_c(this.getUnlocalisedName());
        blockIn.setRegistryName(this.getRegistryName());
        return blockIn;
    }

    @Override
    @Nonnull
    public final <I extends Item> I apply(@Nonnull I itemIn) {
        itemIn.func_77655_b(this.getUnlocalisedName());
        itemIn.setRegistryName(this.getRegistryName());
        return itemIn;
    }

    @Override
    @Nullable
    public String getBlockMethodName() {
        return this.blockMethodName;
    }

    @Override
    @Nullable
    public String getItemMethodName() {
        return this.itemMethodName;
    }
}

