/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry.farmers;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.integration.forestry.ForestryItemStacks;
import crazypants.enderio.util.Prep;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForestryFarmer
extends IForgeRegistryEntry.Impl<IFarmerJoe>
implements IFarmerJoe {
    private ITreeRoot root = null;

    public ForestryFarmer() {
        this.setRegistryName("enderiointegrationforestry", "treefarmer");
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        return this.isValid() && stack.func_77973_b() == ForestryItemStacks.FORESTRY_SAPLING.func_77973_b() && this.getRoot().getType(stack) == EnumGermlingType.SAPLING;
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState state) {
        ITree tree;
        ItemStack sapling;
        if (this.isValid() && (sapling = farm.getSeedTypeInSuppliesFor(bc)).func_77973_b() == ForestryItemStacks.FORESTRY_SAPLING.func_77973_b() && (tree = this.getRoot().getMember(sapling)) != null && tree.canStay((IBlockAccess)farm.getWorld(), bc) && Prep.isValid(farm.takeSeedFromSupplies(bc))) {
            this.getRoot().plantSapling(farm.getWorld(), tree, farm.getFakePlayer().func_146103_bH(), bc);
            return true;
        }
        return false;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState state) {
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull Block block, @Nonnull IBlockState state) {
        return null;
    }

    private ITreeRoot getRoot() {
        if (this.root == null && NullHelper.untrust((Object)AlleleManager.alleleRegistry) != null) {
            this.root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
        }
        return this.root;
    }

    public boolean isValid() {
        return ForestryItemStacks.FORESTRY_SAPLING != null && this.getRoot() != null;
    }
}

