/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.gui.RedstoneModeButton;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.gui.BaseSettingsPanel;
import crazypants.enderio.conduits.gui.ConduitRedstoneModeControlable;
import crazypants.enderio.conduits.gui.GuiExternalConnection;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.network.PacketEnderLiquidConduit;
import crazypants.enderio.conduits.network.PacketExtractMode;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LiquidSettings
extends BaseSettingsPanel {
    static final int ID_REDSTONE_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_INSERT_CHANNEL = GuiExternalConnection.nextButtonId();
    private static final int ID_EXTRACT_CHANNEL = GuiExternalConnection.nextButtonId();
    private static final int ID_PRIORITY_UP = GuiExternalConnection.nextButtonId();
    private static final int ID_PRIORITY_DOWN = GuiExternalConnection.nextButtonId();
    private static final int ID_ROUND_ROBIN = GuiExternalConnection.nextButtonId();
    private static final int ID_LOOP = GuiExternalConnection.nextButtonId();
    private final RedstoneModeButton rsB;
    private final ColorButton colorB;
    private boolean isEnder = false;
    private EnderLiquidConduit eCon;
    private ColorButton insertChannelB;
    private ColorButton extractChannelB;
    private final MultiIconButton priUpB;
    private final MultiIconButton priDownB;
    private final ToggleButton roundRobinB;
    private final ToggleButton loopB;
    private int priLeft = 46;
    private int priWidth = 32;
    private final ILiquidConduit conduit;

    public LiquidSettings(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        super(IconEIO.WRENCH_OVERLAY_FLUID, ConduitObject.item_liquid_conduit.getUnlocalisedName(), gui, con, "in_out_settings");
        this.conduit = (ILiquidConduit)con;
        if (con instanceof EnderLiquidConduit) {
            this.isEnder = true;
            this.eCon = (EnderLiquidConduit)con;
        }
        int x = this.leftColumn;
        int y = this.customTop;
        this.insertChannelB = new ColorButton((IGuiScreen)gui, ID_INSERT_CHANNEL, x, y);
        this.insertChannelB.setColorIndex(0);
        this.insertChannelB.setToolTipHeading(Lang.GUI_CONDUIT_CHANNEL.get());
        x = this.rightColumn;
        this.extractChannelB = new ColorButton((IGuiScreen)gui, ID_EXTRACT_CHANNEL, x, y);
        this.extractChannelB.setColorIndex(0);
        this.extractChannelB.setToolTipHeading(Lang.GUI_CONDUIT_CHANNEL.get());
        this.roundRobinB = new ToggleButton((IGuiScreen)gui, ID_ROUND_ROBIN, x += 4 + this.extractChannelB.getWidth(), y, (IWidgetIcon)IconEIO.ROUND_ROBIN_OFF, (IWidgetIcon)IconEIO.ROUND_ROBIN);
        this.roundRobinB.setSelectedToolTip(new String[]{Lang.GUI_ROUND_ROBIN_ENABLED.get()});
        this.roundRobinB.setUnselectedToolTip(new String[]{Lang.GUI_ROUND_ROBIN_DISABLED.get()});
        this.roundRobinB.setPaintSelectedBorder(false);
        this.loopB = new ToggleButton((IGuiScreen)gui, ID_LOOP, x += 4 + this.roundRobinB.getWidth(), y, (IWidgetIcon)IconEIO.LOOP_OFF, (IWidgetIcon)IconEIO.LOOP);
        this.loopB.setSelectedToolTip(new String[]{Lang.GUI_SELF_FEED_ENABLED.get()});
        this.loopB.setUnselectedToolTip(new String[]{Lang.GUI_SELF_FEED_DISABLED.get()});
        this.loopB.setPaintSelectedBorder(false);
        x = this.rightColumn;
        int x0 = x + 20;
        if (this.isEnder) {
            y += this.insertChannelB.getHeight() + 6;
        }
        this.colorB = new ColorButton((IGuiScreen)gui, ID_COLOR_BUTTON, x0, y);
        this.colorB.setToolTipHeading(Lang.GUI_SIGNAL_COLOR.get());
        this.colorB.setColorIndex(this.conduit.getExtractionSignalColor(gui.getDir()).ordinal());
        this.rsB = new RedstoneModeButton<ConduitRedstoneModeControlable>((IGuiScreen)gui, ID_REDSTONE_BUTTON, x, y, new ConduitRedstoneModeControlable(this.conduit, gui, this.colorB));
        x = this.priLeft + this.priWidth + 9;
        this.priUpB = MultiIconButton.createAddButton((IGuiScreen)gui, (int)ID_PRIORITY_UP, (int)x, (int)y);
        this.priDownB = MultiIconButton.createMinusButton((IGuiScreen)gui, (int)ID_PRIORITY_DOWN, (int)x, (int)(y + 8));
    }

    @Override
    @Nonnull
    public ResourceLocation getTexture() {
        return this.isEnder ? EnderIO.proxy.getGuiTexture("filter_upgrade_settings") : super.getTexture();
    }

    @Override
    public void actionPerformed(@Nonnull GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == ID_COLOR_BUTTON) {
            this.conduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.fromIndex((int)this.colorB.getColorIndex()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.conduit, this.gui.getDir()));
        } else {
            if (guiButton.field_146127_k == 329) {
                this.doOpenFilterGui(4);
                return;
            }
            if (guiButton.field_146127_k == 330) {
                this.doOpenFilterGui(3);
                return;
            }
            if (guiButton.field_146127_k == ID_INSERT_CHANNEL) {
                DyeColor col = DyeColor.values()[this.insertChannelB.getColorIndex()];
                this.eCon.setOutputColor(this.gui.getDir(), col);
            } else if (guiButton.field_146127_k == ID_EXTRACT_CHANNEL) {
                DyeColor col = DyeColor.values()[this.extractChannelB.getColorIndex()];
                this.eCon.setInputColor(this.gui.getDir(), col);
            } else if (guiButton.field_146127_k == ID_PRIORITY_UP) {
                this.eCon.setOutputPriority(this.gui.getDir(), this.eCon.getOutputPriority(this.gui.getDir()) + 1);
            } else if (guiButton.field_146127_k == ID_PRIORITY_DOWN) {
                this.eCon.setOutputPriority(this.gui.getDir(), this.eCon.getOutputPriority(this.gui.getDir()) - 1);
            } else if (guiButton.field_146127_k == ID_ROUND_ROBIN) {
                this.eCon.setRoundRobinEnabled(this.gui.getDir(), !this.eCon.isRoundRobinEnabled(this.gui.getDir()));
            } else if (guiButton.field_146127_k == ID_LOOP) {
                this.eCon.setSelfFeedEnabled(this.gui.getDir(), !this.eCon.isSelfFeedEnabled(this.gui.getDir()));
            }
        }
        if (this.isEnder) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketEnderLiquidConduit(this.eCon, this.gui.getDir()));
        }
    }

    @Override
    protected void connectionModeChanged(@Nonnull ConnectionMode conectionMode) {
        super.connectionModeChanged(conectionMode);
        if (this.isEnder) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.eCon, this.gui.getDir()));
        }
        this.updateGuiVisibility();
    }

    @Override
    protected void initCustomOptions() {
        this.gui.getContainer().setInOutSlotsVisible(true, true, this.conduit);
        this.createGhostSlots();
        this.updateGuiVisibility();
    }

    private void createGhostSlots() {
        NNList filtersAll = new NNList((Object[])new ItemStack[]{new ItemStack(ModObject.itemFluidFilter.getItemNN())});
        NNList upgrades = new NNList((Object[])new ItemStack[]{new ItemStack(ConduitObject.item_extract_speed_upgrade.getItemNN()), new ItemStack(ConduitObject.item_extract_speed_downgrade.getItemNN())});
        this.gui.getContainer().createGhostSlots((NNList<GhostSlot>)this.gui.getGhostSlotHandler().getGhostSlots(), (NNList<ItemStack>)filtersAll, (NNList<ItemStack>)upgrades);
    }

    private void updateGuiVisibility() {
        this.rsB.onGuiInit();
        this.rsB.setMode(RedstoneControlMode.IconHolder.getFromMode(this.conduit.getExtractionRedstoneMode(this.gui.getDir())));
        if (this.isEnder) {
            this.insertChannelB.onGuiInit();
            this.insertChannelB.setColorIndex(this.eCon.getOutputColor(this.gui.getDir()).ordinal());
            this.extractChannelB.onGuiInit();
            this.extractChannelB.setColorIndex(this.eCon.getInputColor(this.gui.getDir()).ordinal());
            this.priUpB.onGuiInit();
            this.priDownB.onGuiInit();
            this.roundRobinB.onGuiInit();
            this.roundRobinB.setSelected(this.eCon.isRoundRobinEnabled(this.gui.getDir()));
            this.loopB.onGuiInit();
            this.loopB.setSelected(this.eCon.isSelfFeedEnabled(this.gui.getDir()));
        }
    }

    @Override
    public void deactivate() {
        this.gui.getContainer().setInOutSlotsVisible(false, false, this.conduit);
        this.rsB.detach();
        this.colorB.detach();
        this.insertChannelB.detach();
        this.extractChannelB.detach();
        this.priDownB.detach();
        this.priUpB.detach();
        this.roundRobinB.detach();
        this.loopB.detach();
    }

    @Override
    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
        if (!this.isEnder) {
            return;
        }
        FontRenderer fr = this.gui.getFontRenderer();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        IconEIO.map.render((IWidgetIcon)EnderWidget.BUTTON_DOWN, (double)(this.left + this.priLeft), (double)(top - 5), (double)this.priWidth, 16.0, 0.0, true);
        String str = this.eCon.getOutputPriority(this.gui.getDir()) + "";
        int sw = fr.func_78256_a(str);
        String priority = Lang.GUI_PRIORITY.get();
        fr.func_78276_b(priority, this.left + 12, top + 25, ColorUtil.getRGB((Color)Color.black));
        fr.func_78276_b(str, this.left + this.priLeft + this.priWidth - sw - this.gap, top + 25, ColorUtil.getRGB((Color)Color.black));
    }

    @Override
    protected boolean hasFilters() {
        return true;
    }
}

