/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.IItemFilterUpgrade;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.filter.fluid.items.IItemFilterFluidUpgrade;
import crazypants.enderio.base.filter.item.items.IItemFilterItemUpgrade;
import crazypants.enderio.conduits.capability.IUpgradeHolder;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InventoryUpgrades
implements IItemHandlerModifiable {
    @Nonnull
    private EnumFacing dir;
    private IFilterHolder<IFilter> filterHolder;
    private IUpgradeHolder upgradeHolder;

    public InventoryUpgrades(@Nonnull EnumFacing dir) {
        this.dir = dir;
    }

    public void setFilterHolder(IFilterHolder<IFilter> filterHolder) {
        this.filterHolder = filterHolder;
    }

    public void setUpgradeHolder(IUpgradeHolder upgradeHolder) {
        this.upgradeHolder = upgradeHolder;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        switch (slot) {
            case 0: {
                return this.upgradeHolder != null ? this.upgradeHolder.getUpgradeStack(this.dir.ordinal()) : ItemStack.field_190927_a;
            }
            case 2: {
                return this.filterHolder != null ? this.filterHolder.getFilterStack(this.filterHolder.getInputFilterIndex(), this.dir.ordinal()) : ItemStack.field_190927_a;
            }
            case 3: {
                return this.filterHolder != null ? this.filterHolder.getFilterStack(this.filterHolder.getOutputFilterIndex(), this.dir.ordinal()) : ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack slotStack = stack.func_77979_a(this.getSlotLimit(slot));
        if (!simulate) {
            this.setInventorySlotContents(slot, slotStack);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack remaining;
        ItemStack result;
        ItemStack current = this.getStackInSlot(slot);
        if (current.func_190926_b()) {
            return current;
        }
        if (amount >= current.func_190916_E()) {
            result = current.func_77946_l();
            remaining = ItemStack.field_190927_a;
        } else {
            result = current.func_77946_l();
            result.func_190920_e(amount);
            remaining = current.func_77946_l();
            remaining.func_190918_g(amount);
        }
        if (!simulate) {
            this.setInventorySlotContents(slot, remaining);
        }
        return result;
    }

    private void setInventorySlotContents(int slot, @Nonnull ItemStack stack) {
        switch (slot) {
            case 0: {
                if (this.upgradeHolder == null) break;
                this.upgradeHolder.setUpgradeStack(this.dir.ordinal(), stack);
                break;
            }
            case 2: {
                if (this.filterHolder == null) break;
                this.filterHolder.setFilterStack(this.filterHolder.getInputFilterIndex(), this.dir.ordinal(), stack);
                break;
            }
            case 3: {
                if (this.filterHolder == null) break;
                this.filterHolder.setFilterStack(this.filterHolder.getOutputFilterIndex(), this.dir.ordinal(), stack);
            }
        }
    }

    public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack, IConduit con) {
        if (stack.func_190926_b()) {
            return false;
        }
        switch (slot) {
            case 0: {
                return stack.func_77973_b() instanceof ItemFunctionUpgrade;
            }
            case 2: {
                return this.isFilterUpgradeAccepted(stack, con);
            }
            case 3: {
                return this.isFilterUpgradeAccepted(stack, con);
            }
        }
        return false;
    }

    private boolean isFilterUpgradeAccepted(@Nonnull ItemStack stack, IConduit con) {
        if (con instanceof IItemConduit) {
            return stack.func_77973_b() instanceof IItemFilterItemUpgrade;
        }
        if (con instanceof ILiquidConduit) {
            return stack.func_77973_b() instanceof IItemFilterFluidUpgrade;
        }
        return stack.func_77973_b() instanceof IItemFilterUpgrade;
    }

    public int getSlots() {
        return 4;
    }

    public int getSlotLimit(int slot) {
        return slot == 0 ? 15 : 1;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.setInventorySlotContents(slot, stack);
    }
}

