/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IFilterChangeListener;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.filter.network.IOpenFilterRemoteExec;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.network.PacketConnectionMode;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BaseSettingsPanel
extends Gui
implements ITabPanel,
IOpenFilterRemoteExec.GUI {
    static final int ID_INSERT_ENABLED = 327;
    static final int ID_EXTRACT_ENABLED = 328;
    protected static final int ID_INSERT_FILTER_OPTIONS = 329;
    protected static final int ID_EXTRACT_FILTER_OPTIONS = 330;
    @Nonnull
    protected final IconEIO icon;
    @Nonnull
    protected final IGuiExternalConnection gui;
    @Nonnull
    protected IClientConduit con;
    @Nonnull
    protected final String typeName;
    @Nonnull
    protected final ResourceLocation texture;
    protected ConnectionMode oldConnectionMode;
    @Nonnull
    private String inputHeading;
    @Nonnull
    private String outputHeading;
    private boolean insertEnabled = false;
    private boolean extractEnabled = false;
    @Nonnull
    private final CheckBox extractEnabledB;
    @Nonnull
    private final CheckBox insertEnabledB;
    @Nonnull
    private IconButton insertFilterOptionsB;
    @Nonnull
    private IconButton extractFilterOptionsB;
    protected int left = 0;
    protected int top = 0;
    protected int width = 0;
    protected int height = 0;
    protected int rightColumn = 112;
    protected int leftColumn = 22;
    protected int gap = 5;
    protected int customTop = 0;

    protected BaseSettingsPanel(@Nonnull IconEIO icon, @Nonnull String typeName, @Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con, @Nonnull String texture) {
        this.icon = icon;
        this.typeName = typeName;
        this.gui = gui;
        this.con = con;
        this.texture = EnderIO.proxy.getGuiTexture(texture);
        this.inputHeading = this.getInputHeading();
        this.outputHeading = this.getOutputHeading();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        this.customTop = this.top + this.gap * 5 + fr.field_78288_b * 2;
        this.customTop -= 16;
        int x = this.leftColumn;
        int y = 6;
        this.insertEnabledB = new CheckBox((IGuiScreen)gui, 327, x, y);
        x = this.rightColumn;
        this.extractEnabledB = new CheckBox((IGuiScreen)gui, 328, x, y);
        x = this.leftColumn;
        y = 92;
        this.insertFilterOptionsB = new IconButton((IGuiScreen)gui, 329, x, y, (IWidgetIcon)IconEIO.GEAR_LIGHT);
        this.insertFilterOptionsB.setToolTip(new String[]{crazypants.enderio.base.lang.Lang.GUI_EDIT_ITEM_FILTER.get()});
        x = this.rightColumn;
        this.extractFilterOptionsB = new IconButton((IGuiScreen)gui, 330, x, y, (IWidgetIcon)IconEIO.GEAR_LIGHT);
        this.extractFilterOptionsB.setToolTip(new String[]{crazypants.enderio.base.lang.Lang.GUI_EDIT_ITEM_FILTER.get()});
        if (this.hasFilters()) {
            gui.getContainer().addFilterListener(new IFilterChangeListener(){

                @Override
                public void onFilterChanged() {
                    BaseSettingsPanel.this.filtersChanged();
                }
            });
        }
        gui.getContainer().setInOutSlotsVisible(false, false, con);
    }

    protected void filtersChanged() {
        this.insertFilterOptionsB.onGuiInit();
        this.extractFilterOptionsB.onGuiInit();
        if (this.gui.getContainer().hasFilter(true)) {
            this.insertFilterOptionsB.setIsVisible(true);
        } else {
            this.insertFilterOptionsB.setIsVisible(false);
        }
        if (this.gui.getContainer().hasFilter(false)) {
            this.extractFilterOptionsB.setIsVisible(true);
        } else {
            this.extractFilterOptionsB.setIsVisible(false);
        }
    }

    public boolean updateConduit(@Nonnull IClientConduit conduit) {
        this.con = conduit;
        if (this.oldConnectionMode != this.con.getConnectionMode(this.gui.getDir())) {
            this.connectionModeChanged(this.con.getConnectionMode(this.gui.getDir()));
        }
        return true;
    }

    public void onGuiInit(int leftIn, int topIn, int widthIn, int heightIn) {
        this.left = leftIn;
        this.top = topIn;
        this.width = widthIn;
        this.height = heightIn;
        this.updateConduit(this.con);
        this.insertEnabledB.onGuiInit();
        this.extractEnabledB.onGuiInit();
        this.insertEnabledB.setSelected(this.insertEnabled);
        this.extractEnabledB.setSelected(this.extractEnabled);
        this.initCustomOptions();
    }

    protected void initCustomOptions() {
    }

    public void deactivate() {
        this.insertEnabledB.detach();
        this.extractEnabledB.detach();
        this.insertFilterOptionsB.detach();
        this.extractFilterOptionsB.detach();
    }

    public void mouseClicked(int x, int y, int par3) {
    }

    public void keyTyped(char par1, int par2) {
    }

    public void updateScreen() {
    }

    @Nonnull
    public IWidgetIcon getIcon() {
        return this.icon;
    }

    @Nonnull
    public ResourceLocation getTexture() {
        return this.texture;
    }

    private void updateConnectionMode() {
        ConnectionMode mode = ConnectionMode.DISABLED;
        if (this.insertEnabled && this.extractEnabled) {
            mode = ConnectionMode.IN_OUT;
        } else if (this.insertEnabled) {
            mode = ConnectionMode.OUTPUT;
        } else if (this.extractEnabled) {
            mode = ConnectionMode.INPUT;
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConnectionMode(this.con, this.gui.getDir(), mode));
    }

    public void actionPerformed(@Nonnull GuiButton guiButton) {
        if (guiButton.field_146127_k == 327) {
            this.insertEnabled = !this.insertEnabled;
            this.updateConnectionMode();
        } else if (guiButton.field_146127_k == 328) {
            this.extractEnabled = !this.extractEnabled;
            this.updateConnectionMode();
        }
    }

    protected void connectionModeChanged(@Nonnull ConnectionMode mode) {
        this.oldConnectionMode = mode;
        this.insertEnabled = mode.acceptsOutput();
        this.extractEnabled = mode.acceptsInput();
    }

    public void render(float par1, int par2, int par3) {
        FontRenderer fr = this.gui.getFontRenderer();
        int rgb = ColorUtil.getRGB((Color)Color.darkGray);
        int x = this.left + 32;
        int y = this.gui.getGuiTop() + 10;
        fr.func_78276_b(this.inputHeading, x, y, rgb);
        fr.func_78276_b(this.outputHeading, x += 92, y, rgb);
        this.renderCustomOptions(y + this.gap + fr.field_78288_b + this.gap, par1, par2, par3);
    }

    protected void renderCustomOptions(int topIn, float par1, int par2, int par3) {
    }

    @Nonnull
    protected String getTypeName() {
        return this.typeName;
    }

    protected boolean hasFilters() {
        return false;
    }

    @Override
    public void setGuiID(int id) {
        this.gui.setGuiID(id);
    }

    @Override
    public int getGuiID() {
        return this.gui.getGuiID();
    }

    @Nonnull
    protected String getInputHeading() {
        return Lang.GUI_CONDUIT_INSERT_MODE.get();
    }

    @Nonnull
    protected String getOutputHeading() {
        return Lang.GUI_CONDUIT_EXTRACT_MODE.get();
    }
}

