/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.redstone;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import crazypants.enderio.base.conduit.redstone.signals.SignalSource;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.config.ConduitConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class RedstoneConduitNetwork
extends AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> {
    private final Multimap<SignalSource, Signal> signals = ArrayListMultimap.create();
    boolean updatingNetwork = false;
    private boolean networkEnabled = true;

    public RedstoneConduitNetwork() {
        super(IRedstoneConduit.class, IRedstoneConduit.class);
    }

    @Override
    public void init(@Nonnull IConduitBundle tile, Collection<IRedstoneConduit> connections, @Nonnull World world) {
        super.init(tile, connections, world);
        this.updatingNetwork = true;
        this.notifyNeigborsOfSignalUpdate();
        this.updatingNetwork = false;
    }

    @Override
    public void destroyNetwork() {
        this.updatingNetwork = true;
        for (IRedstoneConduit con : this.getConduits()) {
            con.setActive(false);
        }
        this.signals.clear();
        this.notifyNeigborsOfSignalUpdate();
        this.updatingNetwork = false;
        super.destroyNetwork();
    }

    @Override
    public void addConduit(@Nonnull IRedstoneConduit con) {
        super.addConduit(con);
        this.updateInputsFromConduit(con, true);
    }

    public void updateInputsFromConduit(@Nonnull IRedstoneConduit con, boolean delayUpdate) {
        BlockPos pos = con.getBundle().getLocation();
        this.updatingNetwork = true;
        this.notifyConduitNeighbours(con);
        this.updatingNetwork = false;
        Set<EnumFacing> externalConnections = con.getExternalConnections();
        for (EnumFacing side : EnumFacing.values()) {
            if (externalConnections.contains(side)) {
                this.updateInputsForSource(con, new SignalSource(pos, side));
                continue;
            }
            this.signals.removeAll((Object)new SignalSource(pos, side));
        }
        if (!delayUpdate) {
            this.notifyNeigborsOfSignalUpdate();
        }
        if (ConduitConfig.showState.get().booleanValue()) {
            this.updateActiveState();
        }
    }

    private void updateActiveState() {
        boolean isActive = false;
        for (Signal s : this.getSignals().values()) {
            if (s.getStrength() <= 0) continue;
            isActive = true;
            break;
        }
        for (IRedstoneConduit con : this.getConduits()) {
            con.setActive(isActive);
        }
    }

    private void updateInputsForSource(@Nonnull IRedstoneConduit con, @Nonnull SignalSource source) {
        this.updatingNetwork = true;
        this.signals.removeAll((Object)source);
        Set<Signal> sigs = con.getNetworkInputs(source.getDir());
        if (sigs != null && !sigs.isEmpty()) {
            this.signals.putAll((Object)source, sigs);
        }
        this.updatingNetwork = false;
    }

    public Multimap<SignalSource, Signal> getSignals() {
        if (this.networkEnabled) {
            return this.signals;
        }
        return ArrayListMultimap.create();
    }

    void setNetworkEnabled(boolean enabled) {
        this.networkEnabled = enabled;
    }

    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    @Override
    public String toString() {
        return "RedstoneConduitNetwork [signals=" + this.signalsString() + ", conduits=" + this.conduitsString() + "]";
    }

    private String conduitsString() {
        StringBuilder sb = new StringBuilder();
        for (IRedstoneConduit con : this.getConduits()) {
            TileEntity te = con.getBundle().getEntity();
            sb.append("<").append(te.func_174877_v().func_177958_n()).append(",").append(te.func_174877_v().func_177956_o()).append(",").append(te.func_174877_v().func_177952_p()).append(">");
        }
        return sb.toString();
    }

    String signalsString() {
        StringBuilder sb = new StringBuilder();
        for (Signal s : this.signals.values()) {
            sb.append("<");
            sb.append(s);
            sb.append(">");
        }
        return sb.toString();
    }

    public void notifyNeigborsOfSignalUpdate() {
        ArrayList conduitsCopy = new ArrayList(this.getConduits());
        for (IRedstoneConduit con : conduitsCopy) {
            this.notifyConduitNeighbours(con);
        }
    }

    private void notifyConduitNeighbours(@Nonnull IRedstoneConduit con) {
        BlockPos bc1;
        TileEntity te = con.getBundle().getEntity();
        World world = te.func_145831_w();
        if (!world.func_175667_e(bc1 = te.func_174877_v())) {
            return;
        }
        EnumSet<EnumFacing> cons = EnumSet.copyOf(con.getExternalConnections());
        if (!this.neighborNotifyEvent(world, bc1, null, cons)) {
            for (EnumFacing dir : con.getExternalConnections()) {
                BlockPos bc2 = bc1.func_177972_a((EnumFacing)NullHelper.notnull((Object)dir, (String)"Conduit external connections contains null"));
                if (!world.func_175667_e(bc2)) continue;
                world.func_190524_a(bc2, ConduitRegistry.getConduitModObjectNN().getBlockNN(), bc1);
                IBlockState bs = world.func_180495_p(bc2);
                if (!bs.func_185898_k() || this.neighborNotifyEvent(world, bc2, bs, EnumSet.allOf(EnumFacing.class))) continue;
                NNList.NNIterator itr = NNList.FACING.fastIterator();
                while (itr.hasNext()) {
                    EnumFacing dir2 = (EnumFacing)itr.next();
                    BlockPos bc3 = bc2.func_177972_a(dir2);
                    if (bc3.equals((Object)bc1) || !world.func_175667_e(bc3)) continue;
                    world.func_190524_a(bc3, ConduitRegistry.getConduitModObjectNN().getBlockNN(), bc1);
                }
            }
        }
    }

    private boolean neighborNotifyEvent(World world, @Nonnull BlockPos pos, @Nullable IBlockState state, EnumSet<EnumFacing> dirs) {
        return ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)(state == null ? world.func_180495_p(pos) : state), dirs, (boolean)false).isCanceled();
    }

    public void afterChunkUnload(@Nonnull List<IRedstoneConduit> conduits, @Nonnull Multimap<SignalSource, Signal> oldSignals) {
        World world = null;
        for (IRedstoneConduit c : conduits) {
            BlockPos pos;
            if (world == null) {
                world = c.getBundle().getBundleworld();
            }
            if (!world.func_175667_e(pos = c.getBundle().getLocation())) continue;
            this.getConduits().add(c);
            c.setNetwork(this);
        }
        this.signals.clear();
        boolean signalsChanged = false;
        for (Map.Entry s : oldSignals.entries()) {
            if (world != null && world.func_175667_e(((SignalSource)s.getKey()).getSource())) {
                this.signals.put(s.getKey(), s.getValue());
                continue;
            }
            signalsChanged = true;
        }
        if (signalsChanged) {
            this.notifyNeigborsOfSignalUpdate();
        }
    }

    public int getSignalStrengthForColor(DyeColor color) {
        int strength = 0;
        for (Signal signal : this.signals.values()) {
            if (signal.getColor() != color || signal.getStrength() <= strength) continue;
            strength = signal.getStrength();
        }
        return strength;
    }
}

